/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.adapters;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.webtools.model.ModelManager;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.model.api.WebModel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class CommonElementAdapterFactory
implements IAdapterFactory {
    public static IFile getFileForNode(CommonElement node) {
        if (node.eResource() == null) {
            return null;
        }
        IFile file = WorkspaceSynchronizer.getFile((Resource)node.eResource());
        if (file == null) {
            return null;
        }
        String path = CommonElementAdapterFactory.getProperty("web.path.key", node);
        if (path == null) {
            return null;
        }
        IContainer container = Model2Util.getDocumentRootContainer((IVirtualComponent)Model2Util.findComponent((IResource)file));
        if (container != null) {
            return container.getFile((IPath)new Path(path));
        }
        return null;
    }

    public static String getProperty(String name, CommonElement element) {
        String prop = null;
        for (Property property : element.getProperties()) {
            if (!property.getName().equals(name)) continue;
            prop = property.getValue();
        }
        return prop;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof CommonElement) {
            MNode node;
            IFile webPageFile;
            CommonElement ce = (CommonElement)adaptableObject;
            if (adapterType == IFile.class) {
                IFile file = CommonElementAdapterFactory.getFileForNode(ce);
                return file;
            }
            if (adapterType == WebModel.class && ce instanceof MDiagram) {
                MDiagram diagram = (MDiagram)ce;
                if (diagram.eResource() == null) {
                    return null;
                }
                webPageFile = WorkspaceSynchronizer.getFile((Resource)diagram.eResource());
                if (webPageFile != null) {
                    WebModel model = null;
                    try {
                        model = ModelManager.getModel((IVirtualComponent)WebProvider.getVirtualComponent((EObject)diagram));
                    }
                    catch (WebModelCreationException e) {
                        e.printStackTrace();
                    }
                    return model;
                }
            }
            if (adapterType == JSP.class && ce instanceof MNode && (webPageFile = WebProvider.getFileForNode(node = (MNode)ce)) != null) {
                WebModel model = null;
                try {
                    model = ModelManager.getModel((IVirtualComponent)WebProvider.getVirtualComponent((EObject)node));
                    return model.getJSP(webPageFile);
                }
                catch (WebModelCreationException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return null;
    }
}

