<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0" xmlns:xalan="http://xml.apache.org/xslt">

	<xsl:output method="xml" encoding="UTF-8"
		doctype-public="-//IBM//DTD Web Diagram 1.2//EN"
		doctype-system="http://www.ibm.com/dtd/web-diagram_1_2.dtd"
		indent="yes" omit-xml-declaration="no" />

	<xsl:template match="web-diagram">
		<xsl:element name="web-diagram">
			<xsl:attribute name="sig_prefix">
				<xsl:value-of select="string('WDE')"></xsl:value-of>
			</xsl:attribute>
			<xsl:attribute name="sig">
				<xsl:value-of select="string('WDE')"></xsl:value-of>
				<xsl:number level="any"
					count=" //web-digram | //property | //node | //edge" />
			</xsl:attribute>
			<xsl:attribute name="next_sig_index">
				<xsl:value-of select="string('WDE')"></xsl:value-of>
				<xsl:value-of select="count( //web-digram | //property | //node | //edge)+1" />
			</xsl:attribute>
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="description">
		<xsl:copy-of select="." />
	</xsl:template>
	<xsl:template match="properties">
		<xsl:element name="properties">
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="property">

		<xsl:element name="property">
			<xsl:copy-of select="@name" />
			<xsl:copy-of select="@value" />
			<xsl:copy-of select="@displayable" />
			<xsl:copy-of select="@editable" />
			<xsl:attribute name="sig">
				<xsl:value-of select="string('WDE')"></xsl:value-of>
				<xsl:number level="any"
					count=" //web-digram | //property | //node | //edge" />
			</xsl:attribute>
		</xsl:element>

	</xsl:template>
	<xsl:template match="nodes">
		<xsl:element name="nodes">
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="node">

		<xsl:element name="node">
			<xsl:copy-of select="@id" />
			<xsl:copy-of select="@type" />
			<xsl:copy-of select="@deleted" />
			<xsl:attribute name="sig">
				<xsl:value-of select="string('WDE')"></xsl:value-of>
				<xsl:number level="any"
					count=" //web-digram | //property | //node | //edge" />
			</xsl:attribute>
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="location">
		<xsl:copy-of select="." />
	</xsl:template>
	<xsl:template match="size">
		<xsl:copy-of select="." />
	</xsl:template>
	<xsl:template match="edges">
		<xsl:element name="edges">
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="edge">
		<xsl:element name="edge">
			<xsl:copy-of select="@id" />
			<xsl:copy-of select="@type" />
			<xsl:copy-of select="@deleted" />
			<xsl:copy-of select="@source" />
			<xsl:copy-of select="@target" />
			<xsl:attribute name="sig">
				<xsl:value-of select="string('WDE')"></xsl:value-of>
				<xsl:number level="any"
					count=" //web-digram | //property | //node | //edge" />
			</xsl:attribute>
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="bendpoints">
		<xsl:copy-of select="." />
	</xsl:template>

</xsl:stylesheet>
