<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0" xmlns:xalan="http://xml.apache.org/xslt">

	<xsl:output method="xml" encoding="UTF-8"
		doctype-public="-//IBM//DTD Web Diagram 1.2//EN"
		doctype-system="http://www.ibm.com/dtd/web-diagram_1_2.dtd"
		indent="yes" omit-xml-declaration="no" />

	<xsl:template match="web-diagram">

		<xsl:element name="web-diagram">

			<xsl:attribute name="sig_prefix">
				<xsl:value-of select="string('WDE')"></xsl:value-of>
			</xsl:attribute>
			
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>


	</xsl:template>
	<xsl:template match="description">
		<xsl:copy-of select="." />
	</xsl:template>
	<xsl:template match="properties">
		<xsl:element name="properties">
			<!--   <xsl:if test="name(..) = 'web-diagram'">
				<xsl:element name="property">
					<xsl:attribute name="name">
						<xsl:value-of
							select="string('com.ibm.etools.diagram.domain')">
						</xsl:value-of>
					</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:value-of
							select="string('com.ibm.etools.diagram.domain.web')">
						</xsl:value-of>
					</xsl:attribute>
					<xsl:attribute name="shareable">
						<xsl:value-of select="string('true')"></xsl:value-of>
					</xsl:attribute>
					<xsl:attribute name="displayable">
						<xsl:value-of select="string('false')"></xsl:value-of>
					</xsl:attribute>
					<xsl:attribute name="editable">
						<xsl:value-of select="string('false')"></xsl:value-of>
					</xsl:attribute>
	
				</xsl:element>
			</xsl:if>
			-->
			<xsl:if
				test="../@type = 'com.ibm.etools.struts.graphical.providers.edge.ActionMappingLocalForwardEdgeProvider'">
				<xsl:if
					test="count( .//property[@name = 'Forward Name'] ) = 0">
					<xsl:element name="property">
						<xsl:attribute name="name">
							<xsl:value-of
								select="string('Forward Name')">
							</xsl:value-of>
						</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of
								select="string('&lt;new&gt;')">
							</xsl:value-of>
						</xsl:attribute>
						<xsl:attribute name="displayable">
							<xsl:value-of select="string('true')"></xsl:value-of>
						</xsl:attribute>
						<xsl:attribute name="editable">
							<xsl:value-of select="string('true')"></xsl:value-of>
						</xsl:attribute>

					</xsl:element>
				</xsl:if>
			</xsl:if>
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="property">

		<xsl:element name="property">
			<xsl:copy-of select="@name" />
			<xsl:copy-of select="@value" />
			<xsl:attribute name="displayable">
				<xsl:value-of select="string('true')"></xsl:value-of>
			</xsl:attribute>
			<xsl:attribute name="editable">
				<xsl:value-of select="string('true')"></xsl:value-of>
			</xsl:attribute>

		</xsl:element>

	</xsl:template>
	<xsl:template match="nodes">
		<xsl:element name="nodes">
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="node">

		<xsl:element name="node">
			<xsl:copy-of select="@id" />
			<xsl:copy-of select="@type" />
			<xsl:copy-of select="@deleted" />

			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="location">
		<xsl:copy-of select="." />
	</xsl:template>
	<xsl:template match="size">
		<xsl:copy-of select="." />
	</xsl:template>
	<xsl:template match="edges">
		<xsl:element name="edges">
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="edge">
		<xsl:element name="edge">
			<xsl:copy-of select="@id" />
			<xsl:copy-of select="@type" />
			<xsl:copy-of select="@deleted" />
			<xsl:copy-of select="@source" />
			<xsl:copy-of select="@target" />

			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="bendpoints">
		<xsl:copy-of select="." />
	</xsl:template>

</xsl:stylesheet>
