/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.wizards;

import com.ibm.etools.diagram.model.internal.services.DiagramFacetUtil;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIConstants;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.ui.internal.wizards.DiagramWizardPage;
import com.ibm.etools.model2.diagram.web.ui.internal.wizards.WebWizardPage;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.wizards.EditorCreationWizard;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;

public class DiagramCreationWizard
extends EditorCreationWizard {
    private LinkedHashMap<IConfigurationElement, WebWizardPage> dynamicPages = new LinkedHashMap();

    public DiagramCreationWizard() {
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(Messages.WebDiagram);
        if (this.page == null) {
            this.page = new DiagramWizardPage(this.getWorkbench(), this.getSelection());
        }
        this.addPage((IWizardPage)this.page);
    }

    public void updateWizardPages(IProject project) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(WebUIConstants.EXT_PT_WEB_DIAGRAM_WIZ_PAGES);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String reqFacets = element.getAttribute("requiresAnyFacetIds");
            String[] facets = reqFacets.split(",");
            boolean hasFacet = false;
            int j = 0;
            while (j < facets.length) {
                String facetId = facets[j];
                if (DiagramFacetUtil.hasFacet((IProject)project, (String)facetId)) {
                    hasFacet = true;
                    break;
                }
                ++j;
            }
            if (hasFacet) {
                WebWizardPage page = this.dynamicPages.get(element);
                if (page == null) {
                    try {
                        page = (WebWizardPage)((Object)element.createExecutableExtension("class"));
                        page.setWizard((IWizard)this);
                        this.dynamicPages.put(element, page);
                    }
                    catch (CoreException e) {
                        WebUIPlugin.getDefault().getLog().log(e.getStatus());
                    }
                }
                page.setProject(project);
            } else {
                this.dynamicPages.remove(element);
            }
            ++i;
        }
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage p = super.getPreviousPage(page);
        if (p == null) {
            IWizardPage previousIteration = null;
            for (IWizardPage iWizardPage : this.dynamicPages.values()) {
                if (iWizardPage.equals(page)) {
                    return previousIteration;
                }
                previousIteration = iWizardPage;
            }
        }
        return p;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage p = super.getNextPage(page);
        if (p == null) {
            Iterator<WebWizardPage> itr = this.dynamicPages.values().iterator();
            while (itr.hasNext()) {
                IWizardPage aPage = (IWizardPage)itr.next();
                if (!aPage.equals(page)) continue;
                if (itr.hasNext()) {
                    return (IWizardPage)itr.next();
                }
                return null;
            }
            itr = this.dynamicPages.values().iterator();
            if (itr.hasNext()) {
                return (IWizardPage)itr.next();
            }
        }
        return p;
    }

    public void init(IWorkbench workbench, IStructuredSelection sel, boolean open) {
        super.init(workbench, sel);
        this.setWindowTitle(Messages.WebDiagram);
        this.setNeedsProgressMonitor(true);
        if (this.page == null) {
            this.page = new DiagramWizardPage(this.getWorkbench(), this.getSelection());
        }
        this.page.setOpenNewlyCreatedDiagramEditor(open);
    }

    public Collection<WebWizardPage> getWebWizardPages() {
        return Collections.unmodifiableCollection(this.dynamicPages.values());
    }
}

