/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.provider;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.ui.internal.actions.PromptingDialogDeleteAction;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.actions.AddNodeItemAction;
import com.ibm.etools.model2.diagram.web.ui.internal.actions.AddPageDataAction;
import com.ibm.etools.model2.diagram.web.ui.internal.actions.CreateAction;
import com.ibm.etools.model2.diagram.web.ui.internal.actions.ReverseEngineerNodesAction;
import com.ibm.etools.model2.diagram.web.ui.internal.actions.WebDiagramPreferencesAction;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.webtools.model.ModelFactory;
import com.ibm.etools.webtools.model.api.DataNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.GlobalPrintAction;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.ContributionItemService;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramContextMenuProvider;
import org.eclipse.gmf.runtime.diagram.ui.render.actions.CopyToImageAction;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.ui.actions.RunOnServerAction;

public class WebDiagramContextMenuProvider
extends DiagramContextMenuProvider {
    public static final boolean DEBUGOPTIONS = false;
    protected IEditorPart editorPart;
    protected static final String FILE_SUBMENU_GROUP = "topicFileSubmenuGroup";
    protected List allowedMenus = new ArrayList();
    protected List deniedGroupItemIds = new ArrayList();

    public WebDiagramContextMenuProvider(EditPartViewer viewer, ActionRegistry actionRegistry, IEditorPart editorPart) {
        super((IWorkbenchPart)editorPart, viewer);
        this.allowedMenus.add("reverse");
        this.allowedMenus.add("findGroup");
        this.allowedMenus.add("fileGroupWDE");
        this.allowedMenus.add("editWDE");
        this.allowedMenus.add("filterFormatGroup");
        this.allowedMenus.add("viewGroup");
        this.allowedMenus.add("additions");
        this.allowedMenus.add("propertiesGroup");
        this.allowedMenus.add("refactorGroup");
        this.deniedGroupItemIds.add("filtersMenu");
        this.deniedGroupItemIds.add("visualizeMenu");
        this.deniedGroupItemIds.add("properties");
        this.deniedGroupItemIds.add("deleteFromDiagramAction");
        this.deniedGroupItemIds.add("deleteFromModelAction");
        this.editorPart = editorPart;
        editorPart.getSite().registerContextMenu(this.getId(), (MenuManager)this, editorPart.getSite().getSelectionProvider());
    }

    public String getId() {
        return "com.ibm.etools.model2.diagram.web.WebDiagram#PopupMenu";
    }

    public void buildContextMenu(IMenuManager menuManager) {
        IFile webPageFile;
        MenuManager fileMenu = new MenuManager("File", "fileMenuWDE");
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        MNode node = this.getResourceNode();
        if (node != null && !node.isRealized()) {
            CreateAction createAction = new CreateAction(page);
            createAction.init();
            this.addWithoutFilter((IContributionItem)new ActionContributionItem((IAction)createAction));
        }
        this.addWithoutFilter((IContributionItem)fileMenu);
        this.add((IContributionItem)new Separator("editWDE"));
        PromptingDialogDeleteAction delete = new PromptingDialogDeleteAction(part);
        delete.setSelectionProvider((ISelectionProvider)this.getViewer());
        delete.update();
        this.appendToGroup("editWDE", (IAction)delete);
        this.addWithoutFilter((IContributionItem)new Separator("endEditWDE"));
        if (node != null && node.isRealized()) {
            ArrayList<IElementType> lists = new ArrayList<IElementType>();
            EList compartments = node.getCompartments();
            for (Compartment compartment : compartments) {
                if (!"com.ibm.etools.model2.diagram.web.LinksCompartment".equals(compartment.getType()) && !"com.ibm.etools.model2.diagram.struts.ForwardsCompartment".equals(compartment.getType())) continue;
                List elementTypes = ModelingAssistantService.getInstance().getTypesForPopupBar((IAdaptable)compartment);
                for (IElementType t : elementTypes) {
                    lists.add(t);
                }
            }
            ArrayList<IElementType> dataTypes = new ArrayList<IElementType>();
            IFile webPageFile2 = WebProvider.getFileForNode((MNode)node);
            if (webPageFile2 != null) {
                DataNode dummyNode = ModelFactory.eINSTANCE.createDataNode(null);
                IElementType[] type = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)dummyNode);
                IElementType data = ElementTypeRegistry.getInstance().getType("webmodel.data");
                dataTypes.addAll(Arrays.asList(type));
                dataTypes.remove(data);
            }
            Collections.sort(dataTypes, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((IElementType)arg0).getDisplayName().compareTo(((IElementType)arg1).getDisplayName());
                }
            });
            MenuManager insertControlsMenu = new MenuManager(Messages.AddLink, "insertControls");
            for (IElementType nodeItemType : lists) {
                if (nodeItemType == null) continue;
                Image image = IconService.getInstance().getIcon((IAdaptable)nodeItemType);
                ImageDescriptor desc = ImageDescriptor.createFromImage((Image)image, (Device)image.getDevice());
                AddNodeItemAction d = new AddNodeItemAction(page, nodeItemType, node);
                d.setText(nodeItemType.getDisplayName());
                d.setImageDescriptor(desc);
                d.init();
                insertControlsMenu.add((IAction)d);
            }
            MenuManager insertDataMenu = new MenuManager(Messages.AddData, "insertData");
            for (IElementType dType : dataTypes) {
                Image image = IconService.getInstance().getIcon((IAdaptable)dType);
                ImageDescriptor desc = ImageDescriptor.createFromImage((Image)image, (Device)image.getDevice());
                AddPageDataAction d = new AddPageDataAction(page, dType);
                d.setText(dType.getDisplayName());
                d.setImageDescriptor(desc);
                d.init();
                insertDataMenu.add((IAction)d);
            }
            this.appendToGroup("endEditWDE", (IContributionItem)insertControlsMenu);
            this.appendToGroup("endEditWDE", (IContributionItem)insertDataMenu);
        }
        ContributionItemService.getInstance().contributeToPopupMenu((IMenuManager)this, (IWorkbenchPart)this.editorPart);
        if (this.isSelectionAllRealizedNodes()) {
            ReverseEngineerNodesAction action = new ReverseEngineerNodesAction(page);
            action.init();
            this.addWithoutFilter((IContributionItem)new Separator("reverse"));
            this.appendToGroup("reverse", (IAction)action);
        }
        this.addWithoutFilter((IContributionItem)new Separator());
        this.addWithoutFilter((IContributionItem)new Separator("additions"));
        CopyToImageAction copyAction = new CopyToImageAction(page);
        copyAction.init();
        if (copyAction.isEnabled()) {
            this.appendToGroup("additions", (IAction)copyAction);
        }
        if ((webPageFile = WebProvider.getFileForNode((MNode)node)) != null && webPageFile.exists()) {
            RunOnServerAction action = new RunOnServerAction((Object)webPageFile);
            this.appendToGroup("additions", (IAction)action);
        }
        GlobalPrintAction printAction = new GlobalPrintAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
        printAction.init();
        this.addWithoutFilter((IContributionItem)new ActionContributionItem((IAction)new WebDiagramPreferencesAction(part)));
    }

    private MNode getResourceNode() {
        Object selection;
        IStructuredSelection sel = (IStructuredSelection)this.getViewer().getSelection();
        if (sel.size() == 1 && (selection = sel.getFirstElement()) instanceof IGraphicalEditPart) {
            IGraphicalEditPart part = (IGraphicalEditPart)selection;
            EObject o = part.resolveSemanticElement();
            if (o instanceof MNode) {
                return (MNode)o;
            }
            if (o instanceof Item) {
                return ((Item)o).getNode();
            }
            if (o instanceof Compartment) {
                return ((Compartment)o).getParent();
            }
        }
        return null;
    }

    private boolean isSelectionAllRealizedNodes() {
        IStructuredSelection sel = (IStructuredSelection)this.getViewer().getSelection();
        for (Object selection : sel) {
            if (!(selection instanceof IGraphicalEditPart)) continue;
            IGraphicalEditPart part = (IGraphicalEditPart)selection;
            EObject o = part.resolveSemanticElement();
            if (o instanceof MNode) {
                if (((MNode)o).isRealized()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void add(IContributionItem item) {
        if (item != null && item.getId() != null && this.allowedMenus.contains(item.getId())) {
            this.addWithoutFilter(item);
            Debug.println((String)("Top level Item added: " + item.getId()));
        } else {
            Debug.println((String)("Top level Item denied: " + item.getId()));
        }
    }

    protected void addWithoutFilter(IContributionItem item) {
        super.add(item);
    }

    public IMenuManager findMenuUsingPath(String path) {
        IMenuManager manager = super.findMenuUsingPath(path);
        if (manager == null) {
            manager = new MenuManager();
        }
        return manager;
    }

    public void insert(int index, IContributionItem item) {
        try {
            super.insert(index, item);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void insertAfter(String ID, IAction action) {
        try {
            super.insertAfter(ID, action);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void insertAfter(String ID, IContributionItem item) {
        try {
            super.insertAfter(ID, item);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void insertBefore(String ID, IAction action) {
        try {
            super.insertBefore(ID, action);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void insertBefore(String ID, IContributionItem item) {
        try {
            super.insertBefore(ID, item);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void prependToGroup(String groupName, IAction action) {
        try {
            super.prependToGroup(groupName, action);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void prependToGroup(String groupName, IContributionItem item) {
        try {
            super.prependToGroup(groupName, item);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void appendToGroup(String groupName, IAction action) {
        try {
            super.appendToGroup(groupName, action);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void appendToGroup(String groupName, IContributionItem item) {
        try {
            if (!this.deniedGroupItemIds.contains(item.getId())) {
                if ("MoveResource".equals(item.getId())) {
                    Debug.noop();
                }
                Debug.println((String)("Added item to group " + groupName + " id = " + item.getId()));
                super.appendToGroup(groupName, item);
            } else {
                Debug.println((String)("Denied item to group " + groupName + " id = " + item.getId()));
                Debug.noop();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

