/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.properties.sections;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.ui.internal.properties.sections.AbstractWebDiagramPropertySection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;

public class WebPagePropertySection
extends AbstractWebDiagramPropertySection {
    private Hyperlink pathText;

    @Override
    public String getLabel() {
        return Messages.FileName;
    }

    @Override
    public void createAdditionalUI(Composite parent) {
        this.getWidgetFactory().createLabel(parent, Messages.WebPagePropertySection_Path);
        this.pathText = this.getWidgetFactory().createHyperlink(parent, "", 0);
        this.pathText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String fileString = WebPagePropertySection.this.pathText.getText();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileString));
                try {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
                }
                catch (PartInitException e1) {
                    StatusManager.getManager().handle(e1.getStatus(), 3);
                }
            }
        });
        this.pathText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.pathText.setEnabled(true);
    }

    @Override
    public void refresh() {
        IContainer container;
        super.refresh();
        String newValue = this.initialValue();
        if (this.getDiagramFile() != null && (container = WebProvider.getDocumentRootContainer((IFile)this.getDiagramFile())) != null) {
            newValue = Model2Util.getFile((IContainer)container, (String)this.getNewValue()).getFullPath().toString();
        }
        this.pathText.setText(TextProcessor.process((String)newValue));
    }

    @Override
    public void updateAfterCommand() {
    }
}

