/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.projnav;

import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.ui.internal.projnav.OpenNewWebDiagramWizardAction;
import com.ibm.etools.model2.diagram.web.ui.internal.projnav.WebDiagramProjNavElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WebDiagramActionExtension
extends CommonActionProvider
implements IDoubleClickListener {
    private OpenNewWebDiagramWizardAction opennewDiagramWizardAction;
    private Clipboard clip = null;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.opennewDiagramWizardAction = new OpenNewWebDiagramWizardAction(Messages.ProjectNavNew);
        aSite.getStructuredViewer().addDoubleClickListener((IDoubleClickListener)this);
        this.clip = new Clipboard(aSite.getViewSite().getShell().getDisplay());
    }

    public void fillContextMenu(IMenuManager aMenu) {
        IStructuredSelection selection = this.getStructureSelection();
        if (selection == null || selection.getFirstElement() == null) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof WebDiagramProjNavElement) {
            WebDiagramProjNavElement elem = (WebDiagramProjNavElement)obj;
            if (elem.isCategoryElement) {
                IVirtualComponent component = (IVirtualComponent)elem.getParent();
                this.opennewDiagramWizardAction.setProjectContext(component.getProject());
                aMenu.insertBefore("group.new", (IAction)this.opennewDiagramWizardAction);
            }
        }
    }

    public void updateActionBars() {
        super.updateActionBars();
    }

    public void dispose() {
        super.dispose();
        if (this.clip != null) {
            this.clip.dispose();
        }
    }

    private IStructuredSelection getStructureSelection() {
        ActionContext actionContext = this.getContext();
        if (actionContext != null && !actionContext.getSelection().isEmpty() && actionContext.getSelection() instanceof IStructuredSelection) {
            return (IStructuredSelection)actionContext.getSelection();
        }
        return null;
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.opennewDiagramWizardAction.run(selection);
        }
    }
}

