/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.projnav;

import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.ui.internal.projnav.WebDiagramProjNavElement;
import com.ibm.etools.model2.diagram.web.ui.internal.wizards.DiagramCreationWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenNewWebDiagramWizardAction
extends Action {
    private IProject projectContext;

    public OpenNewWebDiagramWizardAction(String text) {
        super(text);
        this.setImageDescriptor(WebUIPlugin.getImageDescriptor("icons/obj16/webdiagram_wiz.gif"));
    }

    public OpenNewWebDiagramWizardAction() {
        this(Messages.WebDiagram);
    }

    public void setProjectContext(IProject project) {
        this.projectContext = project;
    }

    public void run() {
        DiagramCreationWizard wizard = new DiagramCreationWizard();
        IProject project = this.projectContext;
        if (project == null) {
            return;
        }
        wizard.init(WebUIPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)project), true);
        Shell shell = Display.getCurrent().getActiveShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void run(ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() == 1 && ss.getFirstElement() instanceof WebDiagramProjNavElement) {
            WebDiagramProjNavElement element = (WebDiagramProjNavElement)ss.getFirstElement();
            IFile file = (IFile)element.getAdapter(IFile.class);
            if (file == null) {
                return;
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file);
            }
            catch (PartInitException partInitException) {
                WebUIPlugin.getLogger().log(NLS.bind((String)Messages.OpenEditorFailedForX, (Object)file.getName()));
                MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.OpenFailed, (String)NLS.bind((String)Messages.OpenEditorFailedForX, (Object)file.getName()));
            }
        }
    }

    public boolean canActionBeAdded(IProject project) {
        return project != null;
    }

    public boolean isEnabled() {
        return this.canActionBeAdded(this.projectContext);
    }
}

