/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.print;

import com.ibm.etools.model2.diagram.web.ui.internal.WebUIConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.common.core.util.StringStatics;
import org.eclipse.gmf.runtime.common.core.util.StringUtil;
import org.eclipse.gmf.runtime.common.ui.action.actions.IPrintActionHelper;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.printing.actions.DefaultPrintActionHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.SWTDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.util.RenderedDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.util.DiagramPrinterUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;

public class ExamplePrintActionHelper
implements IPrintActionHelper {
    public void doPrint(IWorkbenchPart workbenchPart) {
        Assert.isTrue((boolean)(workbenchPart instanceof IEditorPart));
        IEditorPart editorPart = (IEditorPart)workbenchPart;
        if (!System.getProperty("os.name").toUpperCase().startsWith("WIN")) {
            DefaultPrintActionHelper.doRun((IEditorPart)editorPart, (SWTDiagramPrinter)new RenderedDiagramPrinter(WebUIConstants.PREFERENCES_HINT));
            return;
        }
        DiagramPrinterUtil.printWithSettings((IEditorPart)editorPart, this.createDiagramMap(), (SWTDiagramPrinter)new RenderedDiagramPrinter(WebUIConstants.PREFERENCES_HINT));
    }

    private Map<String, Diagram> createDiagramMap() {
        HashMap<String, Diagram> diagramMap = new HashMap<String, Diagram>();
        List de = EditorService.getInstance().getRegisteredEditorParts();
        for (Object obj : de) {
            DiagramEditor deditor;
            if (!(obj instanceof DiagramEditor) || !((deditor = (DiagramEditor)obj).getEditorInput() instanceof FileEditorInput)) continue;
            FileEditorInput input = (FileEditorInput)deditor.getEditorInput();
            String diagramName = input.getFile().getFullPath().toOSString();
            if (diagramName.startsWith(StringStatics.FILE_SEPARATOR)) {
                diagramName = diagramName.substring(1, diagramName.length());
            }
            diagramName = StringUtil.replaceAll((String)diagramName, (String)StringStatics.FILE_SEPARATOR, (String)"::", (boolean)false);
            diagramMap.put(diagramName, deditor.getDiagram());
        }
        return diagramMap;
    }

    protected boolean isSelectionListener() {
        return true;
    }
}

