/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.migration;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Model;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.services.MigrationService;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIConstants;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LegacyWDEMigrationSAXHandler
extends DefaultHandler {
    private Diagram diagramNotation;
    private MEdge edgeMod = null;
    private String text = null;
    private HashMap sigMap = new HashMap();
    private Stack partStack = new Stack();
    private Bounds locNot;
    private String sourceWidth;
    private String sourceHeight;
    private Resource resource;
    private String originalVersion;
    private List relPoints = new ArrayList();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("web-diagram")) {
            this.beginDiagram(attributes);
        } else if (qName.equals("nodes")) {
            this.beginNodes(attributes);
        } else if (qName.equals("node")) {
            this.beginNode(attributes);
        } else if (qName.equals("location")) {
            this.beginLocation(attributes);
        } else if (qName.equals("size")) {
            this.beginSize(attributes);
        } else if (qName.equals("edges")) {
            this.beginEdges(attributes);
        } else if (qName.equals("edge")) {
            this.beginEdge(attributes);
        } else if (qName.equals("bendpoints")) {
            this.beginBendpoints(attributes);
        } else if (qName.equals("bendpoint")) {
            this.beginBendpoint(attributes);
        } else if (qName.equals("dimensions")) {
            this.beginDimensions(attributes);
        } else if (qName.equals("dimension")) {
            this.beginDimension(attributes);
        } else if (qName.equals("description")) {
            this.beginDescription(attributes);
        } else if (qName.equals("properties")) {
            this.beginProperties(attributes);
        } else if (qName.equals("property")) {
            this.beginProperty(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("web-diagram")) {
            this.endDiagram();
        } else if (qName.equals("nodes")) {
            this.endNodes();
        } else if (qName.equals("node")) {
            this.endNode();
        } else if (qName.equals("location")) {
            this.endLocation();
        } else if (qName.equals("size")) {
            this.endSize();
        } else if (qName.equals("edges")) {
            this.endEdges();
        } else if (qName.equals("edge")) {
            this.endEdge();
        } else if (qName.equals("bendpoints")) {
            this.endBendpoints();
        } else if (qName.equals("bendpoint")) {
            this.endBendpoint();
        } else if (qName.equals("dimensions")) {
            this.endDimensions();
        } else if (qName.equals("dimension")) {
            this.endDimension();
        } else if (qName.equals("description")) {
            this.endDescription();
        } else if (qName.equals("properties")) {
            this.endProperties();
        } else if (qName.equals("property")) {
            this.endProperty();
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if ("-//IBM//DTD Web MDiagram 1.2//EN".equals(publicId)) {
            try {
                return new InputSource(FileLocator.openStream((Bundle)WebUIPlugin.getDefault().getBundle(), (IPath)new Path("dtd/web-diagram_1_2.dtd"), (boolean)false));
            }
            catch (IOException exception) {
                WebUIPlugin.getLogger().log("Could not open Web diagram DTD", (Throwable)exception);
                return null;
            }
        }
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.text(new String(ch, start, length));
    }

    public void ignoreableWhitespace(char[] ch, int start, int length) {
        this.text(new String(ch, start, length));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void warning(SAXParseException e) {
        WebUIPlugin.getLogger().log((Throwable)e);
    }

    @Override
    public void error(SAXParseException e) {
        WebUIPlugin.getLogger().log((Throwable)e);
    }

    public LegacyWDEMigrationSAXHandler(int peekerVersion) {
        this.originalVersion = Integer.toString(peekerVersion);
    }

    void beginDiagram(Attributes attributes) {
        Model model = DiagramModelFactory.eINSTANCE.createModel();
        MDiagram dMod = DiagramModelFactory.eINSTANCE.createMDiagram();
        model.setDiagram(dMod);
        MigrationService.getInstance().migrateElement((CommonElement)dMod, this.originalVersion);
        if (dMod.getElementType() == null) {
            WebUIPlugin.getLogger().log("MigrationService failed to migrate diagram");
        }
        dMod.setVersion("7.0");
        this.diagramNotation = ViewService.createDiagram((EObject)dMod, (String)"com.ibm.etools.model2.diagram.web.WebDiagram", (PreferencesHint)WebUIConstants.PREFERENCES_HINT);
        this.resource.getContents().add((Object)this.diagramNotation);
        this.resource.getContents().add((Object)model);
        this.partStack.push(this.diagramNotation);
    }

    void endDiagram() {
        this.partStack.pop();
    }

    void beginNodes(Attributes attributes) {
    }

    void endNodes() {
    }

    void beginDimensions(Attributes attributes) {
    }

    void endDimensions() {
    }

    void beginNode(Attributes attributes) {
        String type = attributes.getValue("type");
        MNode nodeMod = DiagramModelFactory.eINSTANCE.createMNode();
        nodeMod.setType(type);
        MigrationService.getInstance().migrateElement((CommonElement)nodeMod, this.originalVersion);
        if (nodeMod.getElementType() == null) {
            WebUIPlugin.getLogger().log("MigrationService failed to migrate node type " + type);
            this.pushDummy();
            return;
        }
        ((MDiagram)this.diagramNotation.getElement()).getNodes().add((Object)nodeMod);
        Node nodeNot = ViewService.createNode((View)this.diagramNotation, (EObject)nodeMod, (String)type, (PreferencesHint)WebUIConstants.PREFERENCES_HINT);
        if (nodeNot != null) {
            this.partStack.push(nodeNot);
        } else {
            WebUIPlugin.getLogger().log("WebDiagramReader failed to create node " + type);
        }
        String signature = attributes.getValue("sig");
        if (signature != null) {
            this.sigMap.put(signature, nodeNot);
        }
    }

    private void pushDummy() {
        Diagram d = ViewService.createDiagram((EObject)DiagramModelFactory.eINSTANCE.createMDiagram(), (String)"com.ibm.etools.model2.diagram.web.WebDiagram", (PreferencesHint)WebUIConstants.PREFERENCES_HINT);
        Node dummy = ViewService.createNode((View)d, (EObject)DiagramModelFactory.eINSTANCE.createMNode(), (String)"", (PreferencesHint)WebUIConstants.PREFERENCES_HINT);
        this.partStack.push(dummy);
    }

    void endNode() {
        this.partStack.pop();
    }

    void beginLocation(Attributes attributes) {
        String x = attributes.getValue("x");
        String y = attributes.getValue("y");
        if (this.locNot == null) {
            this.locNot = NotationFactory.eINSTANCE.createBounds();
        }
        this.locNot.setX(MapModeUtil.getMapMode().DPtoLP(Integer.parseInt(x)));
        this.locNot.setY(MapModeUtil.getMapMode().DPtoLP(Integer.parseInt(y)));
    }

    void endLocation() {
        Node node = (Node)this.partStack.peek();
        if (node != null && this.locNot != null) {
            node.setLayoutConstraint((LayoutConstraint)this.locNot);
        }
        this.locNot = null;
    }

    void beginSize(Attributes attributes) {
        if (this.locNot == null) {
            this.locNot = NotationFactory.eINSTANCE.createBounds();
        }
        int width = MapModeUtil.getMapMode().DPtoLP(Integer.parseInt(attributes.getValue("width")));
        int height = MapModeUtil.getMapMode().DPtoLP(Integer.parseInt(attributes.getValue("height")));
        this.locNot.setHeight(height);
        this.locNot.setWidth(width);
    }

    void endSize() {
        Node node = (Node)this.partStack.peek();
        if (node != null && this.locNot != null) {
            node.setLayoutConstraint((LayoutConstraint)this.locNot);
        }
        this.locNot = null;
    }

    void beginEdges(Attributes attributes) {
    }

    void endEdges() {
    }

    void beginEdge(Attributes attributes) {
        String sourceSig = attributes.getValue("source");
        if (sourceSig == null) {
            this.pushDummy();
            return;
        }
        View source = (View)this.sigMap.get(sourceSig);
        if (source == null) {
            this.pushDummy();
            return;
        }
        String targetSig = attributes.getValue("target");
        if (targetSig == null) {
            this.pushDummy();
            return;
        }
        View target = (View)this.sigMap.get(targetSig);
        if (target == null) {
            this.pushDummy();
            return;
        }
        String type = attributes.getValue("type");
        this.edgeMod = DiagramModelFactory.eINSTANCE.createMEdge();
        this.edgeMod.setType(type);
        MigrationService.getInstance().migrateElement((CommonElement)this.edgeMod, this.originalVersion);
        if (this.edgeMod.getElementType() == null) {
            WebUIPlugin.getLogger().log("MigrationService failed to migrate edge type" + type);
            this.pushDummy();
            return;
        }
        this.edgeMod.setSource((MNode)source.getElement());
        this.edgeMod.setTarget((MNode)target.getElement());
        ((MDiagram)this.diagramNotation.getElement()).getModel().getEdges().add((Object)this.edgeMod);
        Edge edgeView = ViewService.createEdge((View)source, (View)target, (EObject)this.edgeMod, (String)type, (PreferencesHint)WebUIConstants.PREFERENCES_HINT);
        this.partStack.push(edgeView);
    }

    void endEdge() {
        this.edgeMod = null;
        this.partStack.pop();
    }

    void beginBendpoints(Attributes attributes) {
    }

    void endBendpoints() {
        RelativeBendpoints activeBendpointsNot = NotationFactory.eINSTANCE.createRelativeBendpoints();
        activeBendpointsNot.setPoints(this.relPoints);
        this.relPoints = null;
    }

    void beginBendpoint(Attributes attributes) {
    }

    void endBendpoint() {
    }

    void beginDimension(Attributes attributes) {
        if (this.sourceWidth == null && this.sourceHeight == null) {
            this.sourceWidth = attributes.getValue("width");
            this.sourceHeight = attributes.getValue("height");
        } else {
            String targetWidth = attributes.getValue("width");
            String targetheight = attributes.getValue("height");
            RelativeBendpoint relPoint = new RelativeBendpoint(MapModeUtil.getMapMode().DPtoLP(Integer.parseInt(this.sourceWidth)), MapModeUtil.getMapMode().DPtoLP(Integer.parseInt(this.sourceHeight)), MapModeUtil.getMapMode().DPtoLP(Integer.parseInt(targetWidth)), MapModeUtil.getMapMode().DPtoLP(Integer.parseInt(targetheight)));
            if (this.relPoints == null) {
                this.relPoints = new ArrayList();
            }
            this.relPoints.add(relPoint);
            this.sourceWidth = null;
            this.sourceHeight = null;
        }
    }

    void endDimension() {
    }

    void beginDescription(Attributes attributes) {
        this.text = null;
    }

    void endDescription() {
        EObject element;
        Node object = (Node)this.partStack.peek();
        if (object != null && this.text != null && (element = object.getElement()) instanceof IPropertyHolder) {
            IPropertyHolder holder = (IPropertyHolder)element;
            Property descProperty = DiagramModelFactory.eINSTANCE.createProperty();
            descProperty.setName("Description");
            descProperty.setValue(this.text);
            holder.getPersistedProperties().add((Object)descProperty);
        }
        this.text = null;
    }

    void beginProperties(Attributes attribute) {
    }

    void endProperties() {
    }

    void beginProperty(Attributes attributes) {
        String displayableString;
        Property propertyModel = DiagramModelFactory.eINSTANCE.createProperty();
        View notationNode = (View)this.partStack.peek();
        CommonElement element = (CommonElement)notationNode.getElement();
        element.getPersistedProperties().add((Object)propertyModel);
        String name = attributes.getValue("name");
        propertyModel.setName(name);
        String value = attributes.getValue("value");
        propertyModel.setValue(value);
        String editableString = attributes.getValue("editable");
        if (editableString != null) {
            propertyModel.setEditable(Boolean.valueOf(editableString).booleanValue());
        }
        if ((displayableString = attributes.getValue("displayable")) != null) {
            propertyModel.setDisplayable(Boolean.valueOf(displayableString).booleanValue());
        }
    }

    void endProperty() {
    }

    void text(String string) {
        this.text = this.text != null ? String.valueOf(this.text) + string : string;
    }

    public Diagram getDiagram() {
        return this.diagramNotation;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}

