/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.ide;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;

public class WorkbenchRunnableAdapter
implements IRunnableWithProgress,
IThreadListener {
    private final IWorkspaceRunnable fWorkspaceRunnable;
    private final ISchedulingRule fRule;
    private final boolean fTransfer;

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule) {
        this(runnable, rule, true);
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule, boolean transfer) {
        Assert.isNotNull((Object)runnable);
        Assert.isNotNull((Object)rule);
        this.fWorkspaceRunnable = runnable;
        this.fRule = rule;
        this.fTransfer = transfer;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.fRule;
    }

    public void threadChange(Thread thread) {
        Job current;
        if (this.fTransfer && (current = Job.getJobManager().currentJob()) != null && current.getRule() != null && current.getRule().contains(this.fRule)) {
            Job.getJobManager().transferRule(current.getRule(), thread);
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            ResourcesPlugin.getWorkspace().run(this.fWorkspaceRunnable, this.fRule, 1, monitor);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }
}

