/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.ide;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelPackage;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Model;
import com.ibm.etools.diagram.model.internal.metamodel.ModelLifecycleManager;
import com.ibm.etools.diagram.model.internal.services.ConfiguratorService;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIConstants;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.ui.internal.wizards.WebWizardPage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.util.IDEEditorUtil;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.UIJob;

public class WebEditorUtil
extends IDEEditorUtil {
    public static final IFile createAndOpenWebDiagram(DiagramFileCreator diagramFileCreator, IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow dWindow, IProgressMonitor progressMonitor, boolean openEditor, boolean saveDiagram, Collection<WebWizardPage> webWizardPages) throws CoreException, IOException {
        return WebEditorUtil.createAndOpenWebDiagram(diagramFileCreator, containerPath, fileName, initialContents, kind, dWindow, progressMonitor, openEditor, saveDiagram, webWizardPages, true);
    }

    public static final IFile createAndOpenWebDiagram(DiagramFileCreator diagramFileCreator, IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow dWindow, IProgressMonitor progressMonitor, boolean openEditor, boolean saveDiagram, Collection<WebWizardPage> webWizardPages, boolean autoOpenPreferenceApplies) throws CoreException, IOException {
        IFile newFile = WebEditorUtil.createNewWebDiagramFile(diagramFileCreator, containerPath, fileName, initialContents, kind, dWindow.getShell(), progressMonitor, WebUIConstants.PREFERENCES_HINT, webWizardPages);
        if (newFile != null && openEditor) {
            OpenEditorJob job = new OpenEditorJob(newFile, dWindow, saveDiagram, autoOpenPreferenceApplies);
            job.schedule();
        }
        return newFile;
    }

    public static final IFile createNewWebDiagramFile(DiagramFileCreator diagramFileCreator, IPath containerFullPath, String fileName, InputStream initialContents, String kind, Shell shell, IProgressMonitor progressMonitor, PreferencesHint preferencesHint, Collection<WebWizardPage> webWizardPages) throws CoreException, IOException {
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)11);
        IFile newDiagramFile = diagramFileCreator.createNewFile(containerFullPath, fileName, initialContents, shell, new IRunnableContext(){

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                runnable.run((IProgressMonitor)mon.newChild(1));
            }
        });
        Resource notationModel = null;
        newDiagramFile.refreshLocal(0, (IProgressMonitor)mon.newChild(1));
        String completeFileName = newDiagramFile.getLocation().toOSString();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        notationModel = resourceSet.createResource(URI.createFileURI((String)completeFileName));
        Model model = DiagramModelFactory.eINSTANCE.createModel();
        model.setId("com.ibm.etools.model2.diagram.web.WebDiagram");
        MDiagram webdiagram = (MDiagram)EMFCoreUtil.create((EObject)model, (EReference)DiagramModelPackage.eINSTANCE.getModel_Diagram(), (EClass)DiagramModelPackage.eINSTANCE.getMDiagram());
        webdiagram.setVersion("7.0");
        webdiagram.setType("com.ibm.etools.model2.diagram.web.WebDiagram");
        mon.worked(1);
        if (webWizardPages != null) {
            for (WebWizardPage page : webWizardPages) {
                page.modifyInitialDiagram(webdiagram);
            }
        }
        mon.worked(1);
        model.setDiagram(webdiagram);
        mon.worked(1);
        boolean addWelcome = ((IPreferenceStore)preferencesHint.getPreferenceStore()).getBoolean("add.welcome.node");
        if (addWelcome) {
            MNode welcomeNode = (MNode)EMFCoreUtil.create((EObject)webdiagram, (EReference)DiagramModelPackage.eINSTANCE.getMDiagram_Nodes(), (EClass)DiagramModelPackage.eINSTANCE.getMNode());
            welcomeNode.setType("com.ibm.etools.model2.diagram.web.WelcomeNode");
            ConfiguratorService.getInstance().configureNew((CommonElement)welcomeNode);
        }
        mon.worked(1);
        Diagram view = ViewService.createDiagram((EObject)webdiagram, (String)kind, (PreferencesHint)preferencesHint);
        if (view != null) {
            notationModel.getContents().add((Object)view);
            mon.worked(1);
            notationModel.getContents().add((Object)model);
            mon.worked(1);
            view.getDiagram().setName(newDiagramFile.getName());
        }
        ConfiguratorService.getInstance().configureNew((CommonElement)webdiagram);
        mon.worked(1);
        ModelLifecycleManager.getInstance().disposeObject((EObject)webdiagram);
        mon.worked(1);
        notationModel.save(Collections.EMPTY_MAP);
        newDiagramFile.refreshLocal(0, (IProgressMonitor)mon.newChild(1));
        if (progressMonitor != null) {
            progressMonitor.done();
        }
        return newDiagramFile;
    }

    private static class OpenEditorJob
    extends UIJob {
        private final IFile newFile;
        private final IWorkbenchWindow dWindow;
        private final boolean saveDiagram;
        private final boolean autoOpenPreferenceApplies;

        public OpenEditorJob(IFile newFile, IWorkbenchWindow dWindow, boolean saveDiagram, boolean autoOpenPreferenceApplies) {
            super(Messages.WebEditorUtil_0);
            this.setUser(false);
            this.newFile = newFile;
            this.dWindow = dWindow;
            this.saveDiagram = saveDiagram;
            this.autoOpenPreferenceApplies = autoOpenPreferenceApplies;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            boolean openEditor = WebUIPlugin.getDefault().getPreferenceStore().getBoolean("open.wde.auto") || !this.autoOpenPreferenceApplies;
            mon.worked(10);
            if (openEditor) {
                IDEEditorUtil.openDiagram((IFile)this.newFile, (IWorkbenchWindow)this.dWindow, (boolean)this.saveDiagram, (IProgressMonitor)mon.newChild(90));
            }
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

