/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.ide;

import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.util.ModelUpdateUtils;
import com.ibm.etools.diagram.ui.internal.actions.PromptingDialogDeleteAction;
import com.ibm.etools.model2.diagram.web.internal.WDEEditingDomainManager;
import com.ibm.etools.model2.diagram.web.internal.WebPlugin;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.dnd.FileDropTargetListener;
import com.ibm.etools.model2.diagram.web.ui.internal.dnd.LocalSelectionDropTargetListener;
import com.ibm.etools.model2.diagram.web.ui.internal.ide.SelectIntoNestedChildKeyHandler;
import com.ibm.etools.model2.diagram.web.ui.internal.ide.WebDiagramCommandStack;
import com.ibm.etools.model2.diagram.web.ui.internal.ide.WebDiagramDocumentProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.ide.WebHelpContextProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.ide.WebPaletteContent;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.ui.internal.provider.WebDiagramContextMenuProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.resourcelisteners.ImageToDiagramUpdateManager;
import com.ibm.etools.model2.diagram.web.ui.internal.resourcelisteners.RefreshCanonicalUpdatesForNewEdgesPostCommitListener;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DocumentProviderRegistry;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.editor.FileDiagramEditorWithFlyoutPalette;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.statushandlers.StatusManager;

public class WebDiagramEditor
extends FileDiagramEditorWithFlyoutPalette {
    private IContextProvider contextprovider;
    private WebDiagramExternalOperationHistoryListener externalOperationHistoryListener = null;
    private boolean modifiedKeyHandler;
    private RefreshCanonicalUpdatesForNewEdgesPostCommitListener updateCanonicalPoliciesListener;

    protected void configureDiagramEditDomain() {
        DiagramEditDomain editDomain = (DiagramEditDomain)this.getDiagramEditDomain();
        ImageToDiagramUpdateManager.registerEditDomain(editDomain);
        editDomain.setActionManager(this.createActionManager());
        CommandStack stack = editDomain.getCommandStack();
        if (stack != null) {
            stack.dispose();
        }
        WebDiagramCommandStack diagramStack = new WebDiagramCommandStack(this.getDiagramEditDomain(), this.getSite());
        diagramStack.setOperationHistory(this.getOperationHistory());
        diagramStack.setUndoContext(this.getUndoContext());
        this.externalOperationHistoryListener = new WebDiagramExternalOperationHistoryListener();
        this.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this.externalOperationHistoryListener);
        editDomain.setCommandStack((CommandStack)diagramStack);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        IDiagramGraphicalViewer viewer = this.getDiagramGraphicalViewer();
        WebDiagramContextMenuProvider provider = new WebDiagramContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry(), (IEditorPart)this);
        viewer.setContextMenu((MenuManager)provider);
        KeyHandler viewerKeyHandler = new SelectIntoNestedChildKeyHandler((GraphicalViewer)viewer).setParent(viewer.getKeyHandler());
        viewer.setKeyHandler(viewerKeyHandler);
    }

    protected void createDiagramEditDomain() {
        DiagramEditDomain editDomain = new DiagramEditDomain((IEditorPart)this);
        editDomain.setActionManager(this.createActionManager());
        this.setEditDomain((DefaultEditDomain)editDomain);
    }

    protected TransactionalEditingDomain createEditingDomain() {
        return super.createEditingDomain();
    }

    public void dispose() {
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            WDEEditingDomainManager.INSTANCE.removeResource(diagram.eResource());
        }
        ImageToDiagramUpdateManager.unregisterEditDomain((DiagramEditDomain)this.getDiagramEditDomain());
        if (this.updateCanonicalPoliciesListener != null) {
            this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.updateCanonicalPoliciesListener);
        }
        if (this.externalOperationHistoryListener != null) {
            this.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this.externalOperationHistoryListener);
        }
        super.dispose();
    }

    public Object getAdapter(Class type) {
        if (View.class == type && this.getGraphicalViewer() != null && this.getGraphicalViewer().getRootEditPart() != null) {
            return this.getGraphicalViewer().getRootEditPart().getContents().getModel();
        }
        if (IFile.class == type) {
            return this.getEditorInput().getAdapter(IFile.class);
        }
        if (IContextProvider.class == type) {
            if (this.contextprovider == null) {
                this.contextprovider = new WebHelpContextProvider(this);
            }
            return this.contextprovider;
        }
        if (type == WebDiagramEditor.class) {
            return this;
        }
        if (type == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", "com.ibm.etools.ui.navigator.SDExplorer", "org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator", "org.eclipse.ui.views.ContentOutline"};
                }
            };
        }
        return super.getAdapter(type);
    }

    protected Object getDefaultPaletteContent() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            return new WebPaletteContent(file);
        }
        return super.getDefaultPaletteContent();
    }

    public DiagramEditPart getDiagramEditPart() {
        IDiagramGraphicalViewer viewer = this.getDiagramGraphicalViewer();
        if (viewer != null) {
            return (DiagramEditPart)viewer.getContents();
        }
        return null;
    }

    protected KeyHandler getKeyHandler() {
        KeyHandler keyHandler = super.getKeyHandler();
        if (!this.modifiedKeyHandler) {
            ActionRegistry registry = this.getActionRegistry();
            PromptingDialogDeleteAction action = new PromptingDialogDeleteAction((IWorkbenchPart)this);
            action.setText(Messages.Delete);
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)"dialogDeleteWDE"));
            keyHandler.put(KeyStroke.getPressed((char)'\b', (int)8, (int)0), this.getActionRegistry().getAction((Object)"dialogDeleteWDE"));
            this.modifiedKeyHandler = true;
        }
        return keyHandler;
    }

    public ShowInContext getShowInContext() {
        ISelection selection = this.getGraphicalViewer().getSelection();
        Object o = ((IStructuredSelection)selection).getFirstElement();
        if (o instanceof IAdaptable) {
            IResource r = (IResource)((IAdaptable)o).getAdapter(IResource.class);
            if (r == null) {
                r = (IFile)((IAdaptable)o).getAdapter(IFile.class);
            }
            if (r != null) {
                return new ShowInContext(null, (ISelection)new StructuredSelection((Object)r));
            }
        }
        return new ShowInContext(null, selection);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new LocalSelectionDropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer()));
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new FileDropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer()));
        this.updateCanonicalPoliciesListener = new RefreshCanonicalUpdatesForNewEdgesPostCommitListener(this.getDiagramGraphicalViewer());
        this.getEditingDomain().addResourceSetListener((ResourceSetListener)this.updateCanonicalPoliciesListener);
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        block11: {
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider == null) {
                return;
            }
            try {
                try {
                    String version = WebProvider.getStringProperty((String)"original.version", (IPropertyHolder)((IPropertyHolder)this.getDiagram().getElement()));
                    if (version != null && !"7.0".equals(version)) {
                        Shell shell = this.getSite().getShell();
                        MessageDialog dialog = new MessageDialog(shell, Messages.Warning, null, Messages.FileSaveAsIncompatibleNewVersion, 4, new String[]{Messages.Save, Messages.SaveAs, Messages.Cancel}, 2);
                        int code = dialog.open();
                        if (code == 1) {
                            this.doSaveAs();
                        } else if (code == 0) {
                            ModelUpdateUtils.updateModelNoUndo((Resource)this.getDiagram().eResource(), (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    WebProvider.deleteStringProperty((String)"original.version", (IPropertyHolder)((IPropertyHolder)WebDiagramEditor.this.getDiagram().getElement()));
                                }
                            }, (boolean)true);
                            provider.aboutToChange((Object)this.getEditorInput());
                            IEditorInput input = this.getEditorInput();
                            provider.saveDocument(progressMonitor, (Object)input, this.getDocumentProvider().getDocument((Object)input), overwrite);
                            this.editorSaved();
                        }
                        break block11;
                    }
                    provider.aboutToChange((Object)this.getEditorInput());
                    IEditorInput input = this.getEditorInput();
                    provider.saveDocument(progressMonitor, (Object)input, this.getDocumentProvider().getDocument((Object)input), overwrite);
                    this.editorSaved();
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        this.handleExceptionOnSave(x, progressMonitor);
                    }
                    provider.changed((Object)this.getEditorInput());
                }
            }
            finally {
                provider.changed((Object)this.getEditorInput());
            }
        }
    }

    protected void setDocumentProvider(IEditorInput input) {
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input, new DocumentProviderRegistry.IDocumentProviderSelector(){

            public boolean select(String documentType) {
                return documentType.equals(IDiagramDocument.class.getName());
            }
        });
        this.setDocumentProvider(provider);
        if (provider instanceof WebDiagramDocumentProvider) {
            ((WebDiagramDocumentProvider)provider).setSite(this.getSite());
        }
    }

    public void setExternalOperationHistoryListenerEnabled(boolean enabled) {
        if (this.externalOperationHistoryListener == null) {
            this.externalOperationHistoryListener = new WebDiagramExternalOperationHistoryListener();
            this.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this.externalOperationHistoryListener);
        }
        this.externalOperationHistoryListener.setEnabled(enabled);
    }

    public void setInput(IEditorInput input) {
        try {
            try {
                this.doSetInput(input, true);
            }
            catch (Throwable e) {
                IDocumentProvider provider;
                CoreException ce = null;
                IStatus status = null;
                if (e instanceof CoreException) {
                    ce = (CoreException)e;
                    status = ce.getStatus();
                } else {
                    status = new Status(4, WebPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.ExceptionDuringEditorOpen, e);
                    ce = new CoreException(status);
                }
                WebPlugin.getDefault().getLog().log(status);
                int openStatus = -1;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                openStatus = window != null && !window.getShell().isVisible() ? 1 : 1;
                if (openStatus == 0) {
                    this.enableSanityChecking(false);
                    Display display = this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WebDiagramEditor.this.getSite().getPage().closeEditor((IEditorPart)WebDiagramEditor.this, false);
                        }
                    });
                    try {
                        IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IEditorInput)input, (String)"org.eclipse.ui.DefaultTextEditor", (boolean)true);
                    }
                    catch (PartInitException e1) {
                        StatusManager.getManager().handle(e1.getStatus(), 3);
                    }
                }
                if ((provider = this.getDocumentProvider()) instanceof WebDiagramDocumentProvider) {
                    ((WebDiagramDocumentProvider)provider).setSite(null);
                }
            }
        }
        finally {
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider instanceof WebDiagramDocumentProvider) {
                ((WebDiagramDocumentProvider)provider).setSite(null);
            }
        }
    }

    private class WebDiagramExternalOperationHistoryListener
    implements IOperationHistoryListener {
        private boolean isEnabled = false;

        private WebDiagramExternalOperationHistoryListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            if (!this.isEnabled) {
                return;
            }
            if (event.getEventType() == 1) {
                IUndoableOperation opt = event.getOperation();
                IUndoContext[] currentContexts = opt.getContexts();
                boolean found = false;
                IUndoContext diagramContext = WebDiagramEditor.this.getUndoContext();
                IUndoContext[] iUndoContextArray = currentContexts;
                int n = currentContexts.length;
                int n2 = 0;
                while (n2 < n) {
                    IUndoContext c = iUndoContextArray[n2];
                    if (c.equals(diagramContext)) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    opt.addContext(WebDiagramEditor.this.getUndoContext());
                }
            }
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }
    }
}

