/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.ide;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.emf.util.Model2Type;
import com.ibm.etools.diagram.model.internal.services.ConfiguratorService;
import com.ibm.etools.diagram.model.util.ModelUpdateUtils;
import com.ibm.etools.model2.diagram.web.internal.WDEEditingDomainManager;
import com.ibm.etools.model2.diagram.web.internal.WebPlugin;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.ide.DiagramIOUtilClone;
import com.ibm.etools.model2.diagram.web.ui.internal.migration.FutureWDEVersionPeeker;
import com.ibm.etools.model2.diagram.web.ui.internal.migration.LegacyWDEMigrator;
import com.ibm.etools.model2.diagram.web.ui.internal.migration.LegacyWDEVersionPeeker;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.ui.internal.resourcelisteners.ModelObjectRemovalListener;
import com.ibm.etools.model2.diagram.web.ui.internal.resourcelisteners.ViewEdgePostCommitListener;
import com.ibm.etools.model2.diagram.web.ui.internal.resourcelisteners.ViewNodePreCommitListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDiagramDocumentProvider;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;

public class WebDiagramDocumentProvider
extends FileDiagramDocumentProvider {
    private static final boolean DEBUGOPTIONS = true;
    private IProgressMonitor loadingProgressMonitor;
    private IWorkbenchPartSite site;

    protected AbstractDocumentProvider.ElementInfo createElementInfo(final Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            IFile file = input.getFile();
            if (file == null) {
                return WebDiagramDocumentProvider.super.createElementInfo(element);
            }
            final AbstractDocumentProvider.ElementInfo[] eholder = new AbstractDocumentProvider.ElementInfo[1];
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            WebDiagramDocumentProvider.this.setLoadingProgressMonitor(monitor);
                            eholder[0] = WebDiagramDocumentProvider.super.createElementInfo(element);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        WebDiagramDocumentProvider.this.setLoadingProgressMonitor(null);
                    }
                }
            };
            try {
                this.getSite().getWorkbenchWindow().run(true, false, runnable);
            }
            catch (InvocationTargetException e) {
                Status stat = new Status(4, WebUIPlugin.getDefault().getBundle().getSymbolicName(), 4, "", e.getCause());
                throw new CoreException((IStatus)stat);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Status stat = new Status(4, WebUIPlugin.getDefault().getBundle().getSymbolicName(), 4, "", (Throwable)e);
                throw new CoreException((IStatus)stat);
            }
            return eholder[0];
        }
        return WebDiagramDocumentProvider.super.createElementInfo(element);
    }

    protected void setDocumentContentFromStorage(IDocument document, IStorage storage) throws CoreException {
        final IProgressMonitor parent = this.getProgressMonitor();
        parent.beginTask(Messages.WebDiagramDocumentProvider_LoadingDiagram, 2000);
        try {
            try {
                TransactionalEditingDomain domain;
                IDiagramDocument diagramDocument;
                Diagram diagram;
                block16: {
                    SubProgressMonitor readMonitor = new SubProgressMonitor(parent, 500);
                    try {
                        try {
                            Resource resource;
                            IFile resourceFile;
                            readMonitor.beginTask("", 2);
                            diagram = (Diagram)document.getContent();
                            if (diagram != null && (resourceFile = WorkspaceSynchronizer.getFile((Resource)(resource = diagram.eResource()))) != null) {
                                if (resourceFile.equals((Object)storage)) {
                                    document.setContent(null);
                                } else {
                                    throw new CoreException((IStatus)new Status(4, WebPlugin.getDefault().getBundle().getSymbolicName(), 4, "FileDocumentProvider.handleElementContentChanged", null));
                                }
                            }
                            diagramDocument = (IDiagramDocument)document;
                            domain = diagramDocument.getEditingDomain();
                            diagram = DiagramIOUtilClone.load(domain, storage, false, this.getProgressMonitor());
                            readMonitor.worked(1);
                            document.setContent((Object)diagram);
                            readMonitor.worked(1);
                        }
                        catch (CoreException e1) {
                            diagramDocument = (IDiagramDocument)document;
                            domain = diagramDocument.getEditingDomain();
                            LegacyWDEVersionPeeker peeker = new LegacyWDEVersionPeeker(storage);
                            final int version = peeker.getVersion();
                            if (version == 0) {
                                FutureWDEVersionPeeker futurePeeker = new FutureWDEVersionPeeker(storage);
                                String futureVersion = futurePeeker.getVersion();
                                if (futureVersion != null && !"7.0".equals(futureVersion)) {
                                    Status futureVersionStatus = new Status(4, WebPlugin.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.FutureDiagramVersionCannotBeLoaded, (Object)futureVersion), (Throwable)e1);
                                    throw new CoreException((IStatus)futureVersionStatus);
                                }
                                throw e1;
                            }
                            readMonitor.subTask(Messages.WebDiagramDocumentProvider_MigratingDiagram);
                            LegacyWDEMigrator reader = new LegacyWDEMigrator();
                            IFile newFile = (IFile)storage.getAdapter(IFile.class);
                            Resource resource = domain.createResource(URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true).toString());
                            final Diagram diagram2 = reader.loadDiagram(storage, resource);
                            Runnable setDiagramRunnble = new Runnable(){

                                @Override
                                public void run() {
                                    MDiagram semanticDiagram = (MDiagram)diagram2.getElement();
                                    Property originalVersion = DiagramModelFactory.eINSTANCE.createProperty();
                                    originalVersion.setName("original.version");
                                    originalVersion.setValue(Integer.toString(version));
                                    semanticDiagram.getTransientProperties().add((Object)originalVersion);
                                }
                            };
                            ModelUpdateUtils.updateModelNoUndo((Resource)resource, (Runnable)setDiagramRunnble, (boolean)true);
                            readMonitor.worked(1);
                            document.setContent((Object)diagram2);
                            readMonitor.worked(1);
                            readMonitor.done();
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        readMonitor.done();
                        throw throwable;
                    }
                    readMonitor.done();
                }
                diagram = (Diagram)document.getContent();
                if (diagram == null) {
                    NullPointerException npe = new NullPointerException();
                    Status nullDiagram = new Status(4, WebPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.EditorDocumentContentIsNull, (Throwable)npe);
                    throw new CoreException((IStatus)nullDiagram);
                }
                ModelUpdateUtils.updateModelNoUndo((Resource)diagram.eResource(), (Runnable)new Runnable(){
                    private Map<EObject, View> map;

                    private View getResourceNodeView(View view) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(view);
                        while (!list.isEmpty()) {
                            View v = (View)list.remove(0);
                            String typeId = v.getType();
                            IElementType type = ElementTypeRegistry.getInstance().getType(typeId);
                            if (type instanceof ISpecializationType && ((ISpecializationType)type).isSpecializationOf(Model2Type.RESOURCENODE)) {
                                return v;
                            }
                            EObject o = v.eContainer();
                            if (o == null) continue;
                            list.add(o);
                        }
                        return null;
                    }

                    @Override
                    public void run() {
                        EList semanticEdges;
                        MDiagram semanticDiagram;
                        ArrayList<EObject> semanticEdgesWithView = new ArrayList<EObject>();
                        EList edges = diagram.getPersistedEdges();
                        SubProgressMonitor postProcess = new SubProgressMonitor(parent, 500);
                        int size = edges.size() * 2 + diagram.getChildren().size();
                        EObject maybeDiagram = diagram.getElement();
                        if (maybeDiagram instanceof MDiagram) {
                            semanticDiagram = (MDiagram)maybeDiagram;
                            semanticEdges = semanticDiagram.getModel().getEdges();
                            size += semanticEdges.size();
                        }
                        postProcess.beginTask("", size);
                        for (Edge edge : edges) {
                            EObject semanticEdge;
                            View newSource;
                            View v = edge.getSource();
                            if (v != null && (newSource = this.getResourceNodeView(v)) != null) {
                                edge.setSource(newSource);
                            }
                            if ((semanticEdge = edge.getElement()) != null) {
                                semanticEdgesWithView.add(semanticEdge);
                            }
                            postProcess.worked(1);
                        }
                        if (maybeDiagram instanceof MDiagram) {
                            semanticDiagram = (MDiagram)maybeDiagram;
                            semanticEdges = semanticDiagram.getModel().getEdges();
                            Iterator iter = semanticEdges.iterator();
                            while (iter.hasNext()) {
                                MEdge edge = (MEdge)iter.next();
                                boolean remove = false;
                                if (!semanticEdgesWithView.contains(edge)) {
                                    remove = true;
                                }
                                if (edge.getSource() == null || edge.getTarget() == null) {
                                    remove = true;
                                }
                                if (!remove) continue;
                                iter.remove();
                            }
                        }
                        EList nodes = diagram.getChildren();
                        for (View view : nodes) {
                            View resourceView = this.getResourceNodeView(view);
                            if (resourceView != null) {
                                ArrayList children = new ArrayList(resourceView.getChildren());
                                for (View child : children) {
                                    DestroyElementCommand.destroy((EObject)child);
                                }
                            }
                            postProcess.worked(1);
                        }
                        for (Edge edge : edges) {
                            if (edge.getSource() == null) {
                                edge.setSource(this.getViewForSemanticEdge(diagram, edge.getElement()));
                            }
                            postProcess.worked(1);
                        }
                        TreeIterator itr = diagram.getElement().eContainer().eAllContents();
                        ArrayList<EObject> list = new ArrayList<EObject>();
                        while (itr.hasNext()) {
                            EObject element = (EObject)itr.next();
                            if (!(element instanceof CommonElement)) continue;
                            list.add(element);
                        }
                        postProcess.done();
                        SubProgressMonitor realization = new SubProgressMonitor(parent, 1000);
                        realization.beginTask("", list.size());
                        realization.subTask(Messages.WebDiagramDocumentProvider_CheckingExistanceOfNodes);
                        for (CommonElement commonElement : list) {
                            ConfiguratorService.getInstance().configureLoad(commonElement);
                            commonElement.refreshRealization();
                            if (commonElement instanceof MNode) {
                                EList compartments = ((MNode)commonElement).getCompartments();
                                for (Compartment c : compartments) {
                                    if (!WebProvider.isLinkCompartment((TypedElement)c) && !"com.ibm.etools.model2.diagram.struts.ForwardsCompartment".equals(c.getType())) continue;
                                    c.refreshItems();
                                }
                            }
                            realization.worked(1);
                        }
                        realization.done();
                    }

                    private View getViewForSemanticEdge(Diagram diagram2, EObject element) {
                        if (diagram2 != null && element instanceof MEdge) {
                            MNode node = ((MEdge)element).getSource();
                            return this.getSemanticNodeToViewMap(diagram2).get(node);
                        }
                        return null;
                    }

                    private Map<EObject, View> getSemanticNodeToViewMap(Diagram diagram2) {
                        if (this.map == null) {
                            this.map = new HashMap<EObject, View>();
                            EList nodes = diagram2.getChildren();
                            for (View nodeView : nodes) {
                                if (nodeView.getElement() == null) continue;
                                this.map.put(nodeView.getElement(), nodeView);
                            }
                        }
                        return this.map;
                    }
                }, (boolean)true);
                diagramDocument = (IDiagramDocument)document;
                domain = diagramDocument.getEditingDomain();
                domain.addResourceSetListener((ResourceSetListener)new ModelObjectRemovalListener((MDiagram)diagram.getElement()));
                domain.addResourceSetListener((ResourceSetListener)new ViewNodePreCommitListener());
                domain.addResourceSetListener((ResourceSetListener)new ViewEdgePostCommitListener());
                diagram.eResource().setModified(false);
                WDEEditingDomainManager.INSTANCE.addResource(diagram.eResource());
            }
            catch (RuntimeException e) {
                Status message = new Status(4, WebPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.WebDiagramDocumentProvider_ReadError, (Throwable)e);
                throw new CoreException((IStatus)message);
            }
        }
        finally {
            parent.done();
        }
    }

    protected void saveDocumentToFile(IDocument document, IFile file, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        super.saveDocumentToFile(document, file, overwrite, monitor);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.getLoadingProgressMonitor();
    }

    protected void setLoadingProgressMonitor(IProgressMonitor progressMonitor) {
        this.loadingProgressMonitor = progressMonitor;
    }

    protected IProgressMonitor getLoadingProgressMonitor() {
        return this.loadingProgressMonitor == null ? new NullProgressMonitor() : this.loadingProgressMonitor;
    }

    public void setSite(IWorkbenchPartSite site) {
        this.site = site;
    }

    public IWorkbenchPartSite getSite() {
        return this.site;
    }
}

