/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.ide;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PrivateTimeTriggeredProgressMonitorDialog
extends ProgressMonitorDialog {
    private int longOperationTime;
    private long triggerTime = -1L;
    private boolean dialogOpened = false;
    private IProgressMonitor wrapperedMonitor;

    public PrivateTimeTriggeredProgressMonitorDialog(Shell parent, int longOperationTime) {
        super(parent);
        this.setOpenOnRun(false);
        this.longOperationTime = longOperationTime;
    }

    public void createWrapperedMonitor() {
        this.wrapperedMonitor = new IProgressMonitor(){
            IProgressMonitor superMonitor;
            {
                this.superMonitor = PrivateTimeTriggeredProgressMonitorDialog.super.getProgressMonitor();
            }

            public void beginTask(String name, int totalWork) {
                this.superMonitor.beginTask(name, totalWork);
                this.checkTicking();
            }

            private void checkTicking() {
                if (PrivateTimeTriggeredProgressMonitorDialog.this.triggerTime < 0L) {
                    PrivateTimeTriggeredProgressMonitorDialog.this.triggerTime = System.currentTimeMillis() + (long)PrivateTimeTriggeredProgressMonitorDialog.this.longOperationTime;
                }
                if (!PrivateTimeTriggeredProgressMonitorDialog.this.dialogOpened && System.currentTimeMillis() > PrivateTimeTriggeredProgressMonitorDialog.this.triggerTime) {
                    PrivateTimeTriggeredProgressMonitorDialog.this.open();
                    PrivateTimeTriggeredProgressMonitorDialog.this.dialogOpened = true;
                }
            }

            public void done() {
                this.superMonitor.done();
                this.checkTicking();
            }

            public void internalWorked(double work) {
                this.superMonitor.internalWorked(work);
                this.checkTicking();
            }

            public boolean isCanceled() {
                return this.superMonitor.isCanceled();
            }

            public void setCanceled(boolean value) {
                this.superMonitor.setCanceled(value);
            }

            public void setTaskName(String name) {
                this.superMonitor.setTaskName(name);
                this.checkTicking();
            }

            public void subTask(String name) {
                this.superMonitor.subTask(name);
                this.checkTicking();
            }

            public void worked(int work) {
                this.superMonitor.worked(work);
                this.checkTicking();
            }
        };
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.wrapperedMonitor == null) {
            this.createWrapperedMonitor();
        }
        return this.wrapperedMonitor;
    }

    public void run(final boolean fork, final boolean cancelable, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        final InvocationTargetException[] invokes = new InvocationTargetException[1];
        final InterruptedException[] interrupt = new InterruptedException[1];
        Runnable dialogWaitRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    PrivateTimeTriggeredProgressMonitorDialog.super.run(fork, cancelable, runnable);
                }
                catch (InvocationTargetException e) {
                    invokes[0] = e;
                }
                catch (InterruptedException e) {
                    interrupt[0] = e;
                }
            }
        };
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        BusyIndicator.showWhile((Display)display, (Runnable)dialogWaitRunnable);
        if (invokes[0] != null) {
            throw invokes[0];
        }
        if (interrupt[0] != null) {
            throw interrupt[0];
        }
    }
}

