/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.figures;

import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.swt.graphics.Color;

public class HyperLinkFigure
extends Clickable {
    private WrappingLabel label;
    private Color activeForeground;
    private Color activeBackground;
    private Color foreground;
    private Color background;

    public HyperLinkFigure() {
        this("");
    }

    public HyperLinkFigure(String text) {
        this.label = new WrappingLabel(text);
        this.setContents((IFigure)this.label);
        this.label.setTextUnderline(true);
        this.label.setTextAlignment(1);
        this.label.setTextWrap(false);
        this.setModel(this.createDefaultModel());
        this.setFocusTraversable(false);
        this.setRequestFocusEnabled(false);
    }

    public void setBackgroundColor(Color bg) {
        super.setBackgroundColor(bg);
        if (this.label != null) {
            this.label.setBackgroundColor(bg);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        if (this.label != null) {
            this.label.setForegroundColor(fg);
        }
    }

    public void setText(String text) {
        if (this.label.getText() != text) {
            this.label.setText(text);
            this.repaint();
        }
    }

    protected void handleSelectionChanged() {
        this.isSelected();
    }

    protected void init() {
        super.init();
        this.addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getPropertyName().equals("mouseover")) {
                    HyperLinkFigure.this.handleMouseOver();
                }
                if (changeEvent.getPropertyName().equals("selected")) {
                    HyperLinkFigure.this.handleSelectionChanged();
                }
            }
        });
    }

    protected void handleMouseOver() {
        if (this.getModel().isMouseOver()) {
            this.setForegroundColor(this.activeForeground);
            this.setBackgroundColor(this.activeBackground);
        } else {
            this.setForegroundColor(this.foreground);
            this.setBackgroundColor(this.background);
        }
    }

    public void setActiveForeground(Color activeForeground) {
        this.activeForeground = activeForeground;
    }

    public void setActiveBackground(Color activeBackground) {
        this.activeBackground = activeBackground;
    }

    public void setRegularForeground(Color foreground) {
        this.foreground = foreground;
        this.setForegroundColor(foreground);
    }

    public void setRegularBackground(Color background) {
        this.background = background;
        this.setBackgroundColor(background);
    }

    public void setFocusTraversable(boolean focusTraversable) {
        super.setFocusTraversable(focusTraversable);
    }

    public boolean isFocusTraversable() {
        return super.isFocusTraversable();
    }

    public WrappingLabel getLabel() {
        return this.label;
    }
}

