/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.editparts;

import com.ibm.etools.model2.diagram.web.ui.internal.editparts.CheckboxEditPart;
import com.ibm.etools.model2.diagram.web.ui.internal.figures.GMFCheckBox;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class NoShowCheckboxEditPart
extends CheckboxEditPart {
    private PreferenceListener preferenceListener;
    private CheckboxListener checkboxListener;

    public NoShowCheckboxEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
        GMFCheckBox doNotShow = (GMFCheckBox)this.getFigure();
        doNotShow.setText(Messages.wde_welcome_DoNotShowThisWelcomeNodeAnymore);
        IPreferenceStore store = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        this.preferenceListener = new PreferenceListener(doNotShow, store);
        this.checkboxListener = new CheckboxListener();
        doNotShow.setSelected(!store.getBoolean("add.welcome.node"));
        store.addPropertyChangeListener((IPropertyChangeListener)this.preferenceListener);
        doNotShow.addChangeListener(this.checkboxListener);
    }

    protected void doTogglePref() {
        GMFCheckBox doNotShow = (GMFCheckBox)this.getFigure();
        doNotShow.removeChangeListener(this.checkboxListener);
        IPreferenceStore store = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        store.setValue("add.welcome.node", !store.getBoolean("add.welcome.node"));
        doNotShow.addChangeListener(this.checkboxListener);
    }

    public void deactivate() {
        IPreferenceStore store = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        store.removePropertyChangeListener((IPropertyChangeListener)this.preferenceListener);
        super.deactivate();
    }

    public void performRequest(Request request) {
        super.performRequest(request);
        if ("open".equals(request.getType())) {
            this.doTogglePref();
        }
    }

    private class CheckboxListener
    implements ChangeListener {
        private CheckboxListener() {
        }

        public void handleStateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getPropertyName().equals("selected")) {
                NoShowCheckboxEditPart.this.doTogglePref();
            }
        }
    }

    private static final class PreferenceListener
    implements IPropertyChangeListener {
        private final GMFCheckBox show;
        private final IPreferenceStore store;

        private PreferenceListener(GMFCheckBox show, IPreferenceStore store) {
            this.show = show;
            this.store = store;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("add.welcome.node".equals(event.getProperty())) {
                this.show.setSelected(!this.store.getBoolean("add.welcome.node"));
            }
        }
    }
}

