/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.editparts;

import com.ibm.etools.model2.diagram.web.ui.internal.editpolicies.WelcomeSelectionEditPolicy;
import com.ibm.etools.model2.diagram.web.ui.internal.figures.HyperLinkFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;

public class HyperlinkEditPart
extends ShapeEditPart {
    private HyperlinkSettings settings;

    public HyperlinkEditPart(View view) {
        super(view);
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = ((HyperLinkFigure)HyperlinkEditPart.this.getFigure()).getLabel().getText();
                }
            };
        }
        return this.accessibleEP;
    }

    protected IFigure createFigure() {
        HyperLinkFigure figure = new HyperLinkFigure();
        ToolbarLayout layout = new ToolbarLayout();
        figure.setLayoutManager((LayoutManager)layout);
        figure.getLabel().setTextAlignment(1);
        figure.getLabel().setTextWrap(false);
        figure.setCursor(this.getSettings().getHyperlinkCursor());
        return figure;
    }

    private HyperlinkSettings getSettings() {
        if (this.settings == null) {
            this.settings = new HyperlinkSettings(PlatformUI.getWorkbench().getDisplay());
        }
        return this.settings;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshFontColor();
    }

    protected void refreshFontColor() {
        super.refreshFontColor();
        HyperLinkFigure figure = (HyperLinkFigure)this.getFigure();
        figure.setRegularForeground(this.getSettings().getForeground());
        figure.setRegularBackground(this.getSettings().getForeground());
        figure.setActiveForeground(this.getSettings().getActiveForeground());
        figure.setActiveBackground(this.getSettings().getActiveForeground());
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new WelcomeSelectionEditPolicy());
    }

    public void deactivate() {
        super.deactivate();
    }

    public void setText(String text) {
        ((HyperLinkFigure)this.getFigure()).setText(text);
    }

    public boolean isSelectable() {
        return true;
    }

    public WrappingLabel getLabel() {
        return ((HyperLinkFigure)this.getFigure()).getLabel();
    }
}

