/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.dialogs;

import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.ui.internal.services.PropertyDisplayService;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameDialog
extends StatusDialog {
    private final String initialText;
    private String newName;
    private final Property nameProperty;

    public RenameDialog(Shell shell, Property nameProperty) {
        super(shell);
        this.nameProperty = nameProperty;
        this.newName = this.initialText = PropertyDisplayService.getInstance().getEditString(nameProperty);
        this.setTitle(Messages.Rename);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(Messages.EnterNewName);
        final Text nameText = new Text(composite, 2048);
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String rawText = nameText.getText();
                RenameDialog.this.updateTextAndStatus(rawText);
            }
        });
        nameText.setText(this.initialText);
        nameText.selectAll();
        this.updateTextAndStatus(this.initialText);
        nameText.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private void updateTextAndStatus(String rawText) {
        String parsedText;
        Status status;
        String valid = PropertyDisplayService.getInstance().isValid(this.nameProperty, rawText);
        if (valid != null) {
            status = new Status(4, WebUIPlugin.getDefault().getBundle().getSymbolicName(), 0, valid, null);
            this.updateStatus((IStatus)status);
        } else {
            status = new Status(0, WebUIPlugin.getDefault().getBundle().getSymbolicName(), 0, "", null);
            this.updateStatus((IStatus)status);
        }
        this.newName = parsedText = PropertyDisplayService.getInstance().parseEditedString(this.nameProperty, rawText);
    }

    public String getNewName() {
        return this.newName;
    }
}

