/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.actions;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.ModelDescriptor;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.EdgeResolverService;
import com.ibm.etools.diagram.model.internal.services.ReverseEngineerConstants;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public class ReverseEngineerNodesCommand
extends AbstractTransactionalCommand
implements IWorkspaceLockMarker {
    private final MDiagram diagram;
    private final IGraphicalEditPart diagramEditPart;
    private final List<Object> selectedNodes;

    public ReverseEngineerNodesCommand(TransactionalEditingDomain domain, String label, Map options, List affectedFiles, MDiagram diagram, PreferencesHint preferencesHint, IGraphicalEditPart diagramEditPart, List<Object> selectedNodes) {
        super(domain, label, options, affectedFiles);
        this.diagram = diagram;
        this.diagramEditPart = diagramEditPart;
        this.selectedNodes = selectedNodes;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        progressMonitor.beginTask("", 6000);
        progressMonitor.subTask(Messages.ResolvingTargetNodes);
        EList allNodes = this.diagram.getNodes();
        List<IElementType> allNodeTypes = allNodes.size() > 0 ? Arrays.asList(ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)((MNode)allNodes.get(0)))) : Collections.EMPTY_LIST;
        HashMap<String, Boolean> reverseEngineerOptions = new HashMap<String, Boolean>();
        reverseEngineerOptions.put("use defaults", Boolean.TRUE);
        reverseEngineerOptions.put(ReverseEngineerConstants.REVERSE_ENGINEERING, Boolean.TRUE);
        ArrayList<Command> createNodeCommands = new ArrayList<Command>();
        SubProgressMonitor selectedNodeMonitor = new SubProgressMonitor(progressMonitor, 2000);
        selectedNodeMonitor.beginTask("", this.selectedNodes.size());
        for (MNode mNode : this.selectedNodes) {
            EList compartments = mNode.getCompartments();
            for (Compartment compartment : compartments) {
                if (WebProvider.isDataCompartment((TypedElement)compartment)) continue;
                EList items = compartment.getItems();
                for (NodeItem item : items) {
                    List genEdgeTypes = EdgeGeneratorService.getInstance().getGenerableEdgeTypes((Item)item);
                    for (IElementType edgeType : genEdgeTypes) {
                        for (IElementType nodeType : allNodeTypes) {
                            List resolvableEdgeTypes = EdgeResolverService.getInstance().getResolvableEdgeTypes(nodeType);
                            if (!resolvableEdgeTypes.contains(edgeType)) continue;
                            List sourceReferences = EdgeGeneratorService.getInstance().generateExistingReferences((Item)item, edgeType, item.getElementType());
                            for (SourceReference ref : sourceReferences) {
                                if (ref == SourceReference.HIDDEN) continue;
                                List nodeDescriptors = EdgeResolverService.getInstance().getTargetableNodeDescriptors(nodeType, ref);
                                for (ModelDescriptor descriptor : nodeDescriptors) {
                                    boolean foundExisting = false;
                                    for (MNode possibleExistingNode : allNodes) {
                                        if (!descriptor.matches(possibleExistingNode)) continue;
                                        foundExisting = true;
                                        break;
                                    }
                                    if (foundExisting) continue;
                                    CreateElementRequest request = new CreateElementRequest(this.getEditingDomain(), (EObject)this.diagram, nodeType);
                                    HashMap<String, Boolean> m = new HashMap<String, Boolean>();
                                    m.putAll(reverseEngineerOptions);
                                    m.put("existing node", Boolean.TRUE);
                                    m.put("target node descriptor", (Boolean)descriptor);
                                    m.put("source reference", (Boolean)ref);
                                    m.put("existing edge", Boolean.TRUE);
                                    request.addParameters(m);
                                    EditCommandRequestWrapper wrapper = new EditCommandRequestWrapper((IEditCommandRequest)request);
                                    Command cmd = this.diagramEditPart.getCommand((Request)wrapper);
                                    createNodeCommands.add(cmd);
                                }
                            }
                        }
                    }
                }
            }
            if (progressMonitor.isCanceled()) {
                return CommandResult.newCancelledCommandResult();
            }
            selectedNodeMonitor.worked(1);
        }
        selectedNodeMonitor.done();
        SubProgressMonitor createNodesMonitor = new SubProgressMonitor(progressMonitor, 2000);
        createNodesMonitor.beginTask("", createNodeCommands.size());
        createNodesMonitor.subTask(Messages.CreatingNodes);
        for (Command cmd : createNodeCommands) {
            cmd.execute();
            createNodesMonitor.worked(1);
            if (!progressMonitor.isCanceled()) continue;
            return CommandResult.newCancelledCommandResult();
        }
        createNodesMonitor.done();
        progressMonitor.subTask(Messages.FindingEdges);
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (MNode mNode : this.selectedNodes) {
            IElementType type = mNode.getElementType();
            ConfigureRequest request = new ConfigureRequest((EObject)mNode, type);
            request.setParameter("configure phase", (Object)"edgePhase");
            request.addParameters(reverseEngineerOptions);
            Command configCmd = this.diagramEditPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)request));
            arrayList.add(configCmd);
        }
        SubProgressMonitor createEdgesMonitor = new SubProgressMonitor(progressMonitor, 2000);
        createEdgesMonitor.beginTask("", arrayList.size());
        createEdgesMonitor.subTask(Messages.CreatingEdges);
        for (Command cmd : arrayList) {
            cmd.execute();
            createEdgesMonitor.worked(1);
            if (!progressMonitor.isCanceled()) continue;
            return CommandResult.newCancelledCommandResult();
        }
        createEdgesMonitor.done();
        progressMonitor.done();
        return CommandResult.newOKCommandResult();
    }
}

