/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.ui.internal.properties.sections;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.emf.workbench.ui.listeners.IValidateEditListener;
import com.ibm.etools.emf.workbench.ui.listeners.ValidateEditListener;
import com.ibm.etools.model2.base.util.JavaResourceFinder;
import com.ibm.etools.model2.diagram.struts.ui.internal.properties.sections.ReadOnlyWarningSection;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.strutsconfig.edit.provider.StrutsconfigItemProviderAdapterFactory;
import com.ibm.etools.struts.strutsconfig.presentation.StrutsconfigEditorData;
import com.ibm.etools.struts.strutsconfig.presentation.vieweradapters.AbstractViewerAdapterListener;
import com.ibm.etools.struts.util.StrutsArtifactEdit;
import com.ibm.etools.webtools.flatui.WidgetFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractNotationPropertiesSection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.j2ee.internal.common.StructuredTextEditingDomain;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;

public abstract class AbstractStrutsSection
extends AbstractNotationPropertiesSection
implements EditModelListener,
AbstractViewerAdapterListener {
    private Composite container;
    private Composite parent;
    private Composite sectionComposite;
    private ReadOnlyWarningSection strutsCommonHeader;
    private StrutsconfigEditorData editorData;
    private WidgetFactory factory;
    private boolean hasWarnings = false;
    private boolean needsRefresh = true;
    private boolean isBeingShown = false;
    private boolean pauseUpdates = false;
    private ILink oldHandle = null;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
    }

    protected final void initializeControls(Composite parent) {
        Layout o = parent.getLayout();
        if (o instanceof FillLayout) {
            ((FillLayout)o).type = 512;
        }
        this.parent = parent;
    }

    private void createClient(StrutsconfigEditorData data) {
        this.container = this.getWidgetFactory().createComposite(this.parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ibm.etools.model2.diagram.web.ui.wde_properties");
        this.container.setLayout((Layout)new GridLayout());
        if (data.getStrutsArtifactEdit().isDirty()) {
            this.sectionComposite = this.getWidgetFactory().createComposite(this.container, 0);
            this.sectionComposite.setLayout((Layout)new GridLayout());
            this.sectionComposite.setLayoutData((Object)new GridData(4, 1, true, false));
            this.strutsCommonHeader = new ReadOnlyWarningSection((FormToolkit)this.getWidgetFactory(), this.getLegacyWidgetFactory(), this.getStrutsConfigFile());
            this.strutsCommonHeader.createControl(this.sectionComposite);
            this.hasWarnings = true;
        } else {
            this.hasWarnings = false;
        }
        this.createSection(this.container, data);
    }

    protected Composite getContainer() {
        return this.container;
    }

    public void dispose() {
        super.dispose();
        this.disposeClient();
    }

    public void disposeClient() {
        if (this.editorData != null) {
            try {
                this.editorData.getStrutsArtifactEdit().removeListener((EditModelListener)this);
                if (this.editorData.getStrutsArtifactEdit().isDirty() && !this.hasWarnings) {
                    this.editorData.getStrutsArtifactEdit().save(null);
                }
            }
            finally {
                this.editorData.getStrutsArtifactEdit().dispose();
                this.editorData = null;
            }
        }
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
        if (this.container != null) {
            this.container.dispose();
        }
        if (this.strutsCommonHeader != null) {
            this.strutsCommonHeader.dispose();
            this.strutsCommonHeader = null;
        }
    }

    public void setPauseUpdates(boolean pauseUpdates) {
        this.pauseUpdates = pauseUpdates;
    }

    public void editModelChanged(EditModelEvent anEvent) {
        if (this.pauseUpdates) {
            return;
        }
        if (anEvent.getEventCode() == 2) {
            this.needsRefresh = true;
            this.hasWarnings = true;
            if (this.isBeingShown) {
                this.postUpdateRequest(new Runnable(){

                    @Override
                    public void run() {
                        AbstractStrutsSection.this.refresh();
                    }
                });
            }
        }
        if (anEvent.getEventCode() == 1) {
            this.needsRefresh = true;
            this.hasWarnings = false;
            if (this.isBeingShown) {
                this.postUpdateRequest(new Runnable(){

                    @Override
                    public void run() {
                        AbstractStrutsSection.this.refresh();
                    }
                });
            }
        }
    }

    public void aboutToBeShown() {
        this.isBeingShown = true;
    }

    public void aboutToBeHidden() {
        this.isBeingShown = false;
        if (this.editorData != null && this.editorData.getStrutsArtifactEdit().isDirty() && !this.hasWarnings) {
            this.editorData.getStrutsArtifactEdit().save(null);
        }
    }

    public void refresh() {
        super.refresh();
        ILink newFile = this.getHandle();
        boolean doRefresh = false;
        if (this.oldHandle == null || newFile == null) {
            doRefresh = true;
        } else if (this.oldHandle != null && !newFile.equals(this.oldHandle)) {
            doRefresh = true;
        }
        if (doRefresh || this.needsRefresh) {
            this.oldHandle = newFile;
            this.disposeClient();
            StrutsconfigEditorData data = this.getEditorData();
            if (data != null) {
                data.getStrutsArtifactEdit().addListener((EditModelListener)this);
                this.createClient(data);
            }
            this.parent.layout();
            this.needsRefresh = false;
        }
    }

    protected abstract void createSection(Composite var1, StrutsconfigEditorData var2);

    protected abstract ILink getHandle();

    public IFile getStrutsConfigFile() {
        ILink link;
        IGraphicalEditPart part = this.getSingleInput();
        if (part == null) {
            return null;
        }
        EObject o = part.resolveSemanticElement();
        if (o == null) {
            return null;
        }
        if (o instanceof CommonElement && (link = (ILink)((CommonElement)o).getAdapter(ILink.class)) != null) {
            return (IFile)link.getContainer().getResource();
        }
        return null;
    }

    private WidgetFactory getLegacyWidgetFactory() {
        if (this.factory == null) {
            this.factory = new WidgetFactory();
        }
        return this.factory;
    }

    private StrutsconfigEditorData createEditorData() {
        StrutsconfigEditorData fData = null;
        IFile strutsConfig = this.getStrutsConfigFile();
        if (strutsConfig != null) {
            StrutsArtifactEdit fStrutsArtifactEdit = StrutsArtifactEdit.getStrutsArtifactEditForWrite((IFile)strutsConfig);
            StrutsconfigItemProviderAdapterFactory fAdapterFactory = new StrutsconfigItemProviderAdapterFactory();
            StructuredTextEditingDomain fEditingDomain = new StructuredTextEditingDomain((AdapterFactory)fAdapterFactory, fStrutsArtifactEdit.getCommandStack());
            IVirtualComponent fComponent = ComponentCore.createComponent((IProject)strutsConfig.getProject());
            fData = new StrutsconfigEditorData();
            fData.setWidgetFactory(this.getLegacyWidgetFactory());
            fAdapterFactory = new StrutsconfigItemProviderAdapterFactory();
            fEditingDomain = new StructuredTextEditingDomain((AdapterFactory)fAdapterFactory, fStrutsArtifactEdit.getCommandStack());
            fData.setEditingDomain(fEditingDomain);
            fData.setStrutsArtifactEdit(fStrutsArtifactEdit);
            fData.setComponent(fComponent);
            ResourceStateValidatorImpl resourceStateValidator = new ResourceStateValidatorImpl(fStrutsArtifactEdit.getResourceStateInputProvider());
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            ValidateEditListener validateEditListener = new ValidateEditListener(part, (ResourceStateValidator)resourceStateValidator);
            fData.setEditValidator((IValidateEditListener)validateEditListener);
            fData.setJavaResourceFinder(new JavaResourceFinder(strutsConfig.getFullPath()));
            boolean isStruts1_1orHigher = StrutsProjectUtil.getStrutsVersion((IProject)fComponent.getProject()) == 1 || StrutsProjectUtil.getStrutsVersion((IProject)fComponent.getProject()) == 2 || StrutsProjectUtil.getStrutsVersion((IProject)fComponent.getProject()) == 3;
            fData.setIsStruts1_1OrHigher(isStruts1_1orHigher);
        }
        return fData;
    }

    private StrutsconfigEditorData getEditorData() {
        if (this.editorData == null) {
            this.editorData = this.createEditorData();
        }
        return this.editorData;
    }

    protected EObject getSemanticObject() {
        IGraphicalEditPart part = this.getSingleInput();
        if (part == null) {
            return null;
        }
        EObject o = part.resolveSemanticElement();
        if (o == null) {
            return null;
        }
        return o;
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    private boolean isControlOurs(Control control) {
        Composite parent = control.getParent();
        while (parent != null) {
            if (parent.equals(this.getContainer())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public void preExecute(Control control) {
        if (this.isControlOurs(control)) {
            this.setPauseUpdates(true);
        }
    }

    public void postExecute(Control control) {
        if (this.isControlOurs(control)) {
            this.setPauseUpdates(false);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
    }
}

