/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.struts.ui.internal.actions;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.ui.internal.adapters.OpenAdapter;
import com.ibm.etools.model2.diagram.struts.internal.nls.Messages;
import com.ibm.etools.model2.diagram.struts.internal.providers.StrutsProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class OpenActionDefinition
extends Action
implements ISelectionListener {
    private final IWorkbenchPartDescriptor partDescriptor;

    public OpenActionDefinition(IWorkbenchPartDescriptor partDescriptor) {
        this.partDescriptor = partDescriptor;
        this.setText(Messages.OpenActionClass);
    }

    private MNode getNodeSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.partDescriptor.getPartPage().getSelection();
        Object first = sel.getFirstElement();
        if (first instanceof IAdaptable) {
            EObject eObject = (EObject)((IAdaptable)first).getAdapter(EObject.class);
            if (eObject instanceof MNode) {
                return (MNode)eObject;
            }
            if (eObject instanceof Item) {
                return ((Item)eObject).getNode();
            }
        }
        return null;
    }

    public void run() {
        MNode node = this.getNodeSelection();
        if (node != null) {
            StrutsActionDefOpenAdapter adapter = new StrutsActionDefOpenAdapter(node);
            try {
                adapter.openEditor();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.isEnabled();
    }

    private static class StrutsActionDefOpenAdapter
    extends OpenAdapter {
        private final MNode node;

        public StrutsActionDefOpenAdapter(MNode node) {
            this.node = node;
        }

        public IFile getFileToOpen() {
            ILink handle = (ILink)this.node.getAdapter(ILink.class);
            if (handle != null) {
                IFile strutsConfig = (IFile)handle.getContainer().getResource();
                return strutsConfig;
            }
            if ("com.ibm.etools.model2.diagram.struts.StrutsGlobalNode".equals(this.node.getType())) {
                String module = StrutsProvider.getModuleName((CommonElement)this.node.getParent());
                IProject project = StrutsProvider.getProjectForElement((CommonElement)this.node);
                try {
                    Set sc = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)project, (String)module, null);
                    if (!sc.isEmpty()) {
                        return (IFile)((ILink)sc.iterator().next()).getContainer().getResource();
                    }
                }
                catch (ReferenceException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public ISelection getSelectionToReveal() {
            ILink handle = (ILink)this.node.getAdapter(ILink.class);
            return new StructuredSelection((Object)handle);
        }
    }
}

