/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.model2.diagram.faces.internal.FacesChangeCommand;
import com.ibm.etools.model2.diagram.faces.internal.edithelper.cmds.TargetNodeAdapter;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import com.ibm.etools.references.web.faces.FacesNavigation;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;
import org.eclipse.osgi.util.NLS;

public class UpdateNavigationRuleResourceCommand
extends ResourceModificationCommand
implements IDeletionCommand {
    private final IAdaptable navCaseAdaptable;
    private final TargetNodeAdapter targetNodeAdapter;
    private final List resourceToDelete;
    private FacesChangeCommand facesChangeCommand;
    private IFile configFile;
    private final MNode sourceNode;
    private final CommandExecutionAprover updateAprover;

    public UpdateNavigationRuleResourceCommand(MNode sourceNode, IAdaptable navCaseAdaptable, TargetNodeAdapter targetNodeAdapter, List resourceToDelete, CommandExecutionAprover updateAprover) {
        super(ResourceHandler.UpdateNavigationRule);
        this.sourceNode = sourceNode;
        this.navCaseAdaptable = navCaseAdaptable;
        this.targetNodeAdapter = targetNodeAdapter;
        this.resourceToDelete = resourceToDelete;
        this.updateAprover = updateAprover;
    }

    public FacesNavigation getNavigationCaseHandle() {
        return (FacesNavigation)this.navCaseAdaptable.getAdapter(FacesNavigation.class);
    }

    public boolean canExecute() {
        return this.sourceNode.isRealized();
    }

    protected IFile getFileToModify() {
        if (this.configFile == null) {
            FacesNavigation handle = this.getNavigationCaseHandle();
            if (handle == null) {
                return null;
            }
            return handle.getFacesConfigFile();
        }
        return this.configFile;
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (!this.updateAprover.isProceed()) {
            return CommandResult.newOKCommandResult();
        }
        final FacesNavigation handle = this.getNavigationCaseHandle();
        if (handle != null) {
            if ("".equals(this.targetNodeAdapter.getTargetPath()) && this.resourceToDelete != null && !this.resourceToDelete.contains(this.getNavigationCaseHandle())) {
                return CommandResult.newOKCommandResult();
            }
            if (this.facesChangeCommand != null) {
                this.facesChangeCommand.dispose();
            }
            FacesChangeCommand.FacesChanges changes = new FacesChangeCommand.FacesChanges(){

                @Override
                protected boolean doFacesChanges(FacesConfigType facesConfig) {
                    ToViewIdType toViewId = FacesConfigFactory.eINSTANCE.createToViewIdType();
                    toViewId.setTextContent(FacesLinkUtil.addLeadingSlash((String)UpdateNavigationRuleResourceCommand.this.targetNodeAdapter.getTargetPath()));
                    NavigationCaseType navCase = handle.getNavigationCase(facesConfig);
                    if (navCase != null) {
                        handle.getNavigationCase(facesConfig).setToViewId(toViewId);
                        return true;
                    }
                    return false;
                }
            };
            this.facesChangeCommand = FacesChangeCommand.getFacesCommand(handle.getFacesConfigFile(), changes, true);
            this.facesChangeCommand.execute();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.facesChangeCommand != null && this.facesChangeCommand.canUndo()) {
            this.facesChangeCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    public void dispose() {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.dispose();
        }
        super.dispose();
    }

    public String getCurrentTarget() {
        return this.getNavigationCaseHandle().getFromOutcome();
    }

    public ResourceTree getDeletionTree() {
        if (this.getNavigationCaseHandle() == null) {
            return null;
        }
        if (this.targetNodeAdapter.getTargetPath().equals("")) {
            ResourceDescriptor desc = new ResourceDescriptor((Object)this.getNavigationCaseHandle());
            desc.setDisplayText(NLS.bind((String)ResourceHandler.UpdateFileXRemoveReferenceToX, (Object)this.getFileToModify().getLocation().lastSegment(), (Object)this.getCurrentTarget()));
            return new ResourceTree(desc);
        }
        return null;
    }
}

