/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.model2.diagram.faces.internal.FacesUtils;
import com.ibm.etools.model2.diagram.faces.internal.UICommandType;
import com.ibm.etools.model2.diagram.faces.internal.edithelper.cmds.FacesTargetUtilities;
import com.ibm.etools.model2.diagram.faces.internal.edithelper.cmds.NavRuleDescriptor;
import com.ibm.etools.model2.diagram.faces.internal.edithelper.cmds.TargetNodeAdapter;
import com.ibm.etools.model2.diagram.faces.internal.edithelper.nodes.FacesCommandHelper;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.model2.diagram.faces.internal.resource.cmds.items.RenameFacesActionInvocationResourceCommand;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class UpdateFacesActionInvocationResourceCommand
extends ResourceModificationCommand
implements IDeletionCommand {
    private final IAdaptable linkHandleAdapter;
    private final List resourceToDelete;
    private final CommandExecutionAprover updateEdgePropertiesAprover;
    private final TargetNodeAdapter targetAdapter;
    private String oldActionName;
    private boolean gotActionName;
    private int index = -2;
    private RenameFacesActionInvocationResourceCommand renameActionInvocation;
    private String actionName;
    private IFile pageCodeFile;
    private boolean addedActionToManagedBean = false;
    private boolean renamedActionInvocation = false;
    private boolean updatedFacesLink = false;
    private IFile jspFile;
    private String path;
    private String tagName;
    private final MNode sourceNode;
    private final CommandExecutionAprover thisAprover;
    private final NavRuleDescriptor descriptor;

    public UpdateFacesActionInvocationResourceCommand(MNode sourceNode, IAdaptable linkHandleAdapter, NavRuleDescriptor descriptor, TargetNodeAdapter targetAdapter, List resourceToDelete) {
        this(sourceNode, linkHandleAdapter, descriptor, targetAdapter, resourceToDelete, new CommandExecutionAprover());
    }

    public UpdateFacesActionInvocationResourceCommand(MNode sourceNode, IAdaptable linkHandleAdapter, NavRuleDescriptor descriptor, TargetNodeAdapter targetAdapter, List resourceToDelete, CommandExecutionAprover updateEdgePropertiesAprover) {
        this(sourceNode, linkHandleAdapter, descriptor, targetAdapter, resourceToDelete, updateEdgePropertiesAprover, new CommandExecutionAprover(true));
    }

    public UpdateFacesActionInvocationResourceCommand(MNode sourceNode, IAdaptable linkHandleAdapter, NavRuleDescriptor descriptor, TargetNodeAdapter targetNodeAdapter, List resourcesToDelete, CommandExecutionAprover updateEdgePropertiesAprover, CommandExecutionAprover thisAprover) {
        super(ResourceHandler.UpdateFacesActionInvocation);
        this.sourceNode = sourceNode;
        this.linkHandleAdapter = linkHandleAdapter;
        this.descriptor = descriptor;
        this.thisAprover = thisAprover;
        this.targetAdapter = targetNodeAdapter;
        this.resourceToDelete = resourcesToDelete;
        this.updateEdgePropertiesAprover = updateEdgePropertiesAprover;
    }

    protected Item getItemFromAdapter() {
        return (Item)this.linkHandleAdapter.getAdapter(Item.class);
    }

    public boolean canExecute() {
        return this.sourceNode.isRealized();
    }

    protected IFile getFileToModify() {
        Item itemFromAdapter = this.getItemFromAdapter();
        if (itemFromAdapter == null) {
            return null;
        }
        return WebProvider.getFileForNode((MNode)itemFromAdapter.getNode());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (!this.thisAprover.isProceed()) {
            return CommandResult.newOKCommandResult();
        }
        if (!this.gotActionName) {
            this.oldActionName = WebProvider.getStringProperty((String)"faces.action.invocation.item.name", (IPropertyHolder)this.getItemFromAdapter());
            this.gotActionName = true;
        }
        ILink sourceHandle = this.getHandle();
        Item item = (Item)this.linkHandleAdapter.getAdapter(Item.class);
        if (sourceHandle != null) {
            this.index = this.getDuplicateIndex(item, FacesLinkUtil.getMBTarget((ILink)sourceHandle), sourceHandle);
            this.jspFile = this.getJspFile();
            this.path = AbstractWebProvider.trimQuotes((String)sourceHandle.getLinkText());
            this.tagName = sourceHandle.getParameter("tagname");
            if (this.targetAdapter != null && (this.targetAdapter.getTargetPath() == null || this.targetAdapter.getTargetPath().length() == 0)) {
                if (this.resourceToDelete != null && this.resourceToDelete.contains(this.getHandle())) {
                    try {
                        String newPath = this.targetAdapter.getTargetPath();
                        FacesTargetUtilities.updateFacesLink(this.index, this.jspFile, this.path, this.tagName, newPath);
                        this.path = newPath;
                    }
                    catch (Exception e) {
                        return DiagramCommandResult.newErrorCommandResult((Throwable)e);
                    }
                    this.updatedFacesLink = true;
                }
            } else if (this.descriptor.isGenerateAction()) {
                String id = null;
                String managedBean = null;
                String uri = FacesLinkUtil.getTaglibURIForTagName((IFile)this.jspFile, (String)this.tagName);
                String idPrefix = JsfComponentUtil.getIdPrefix((String)uri, (String)this.tagName, (IProject)this.jspFile.getProject());
                IStructuredModel model = null;
                try {
                    try {
                        model = StructuredModelManager.getModelManager().getModelForRead(this.jspFile);
                        if (model != null) {
                            IDOMDocument doc = ((IDOMModel)model).getDocument();
                            id = JsfComponentUtil.generateUniqueId((Document)doc, (String)idPrefix, (List)Collections.EMPTY_LIST);
                            managedBean = CodeBehindUtil.getManagedBeanName((IDOMDocument)doc);
                        }
                    }
                    catch (IOException e) {
                        CommandResult commandResult = CommandResult.newErrorCommandResult((Throwable)e);
                        if (model == null) return commandResult;
                        model.releaseFromRead();
                        return commandResult;
                    }
                    catch (CoreException e) {
                        CommandResult commandResult = CommandResult.newErrorCommandResult((Throwable)e);
                        if (model == null) return commandResult;
                        model.releaseFromRead();
                        return commandResult;
                    }
                }
                finally {
                    if (model != null) {
                        model.releaseFromRead();
                    }
                }
                if (id == null || managedBean == null) return CommandResult.newErrorCommandResult((String)ResourceHandler.CouldntGenerateIdForJsfTag);
                this.actionName = "#{" + managedBean + ".do" + id + "Action}";
                this.descriptor.setFromAction(this.actionName);
            } else {
                if (this.targetAdapter != null) {
                    MNode target = this.targetAdapter.getNode();
                    if (FacesProvider.isFacesActionNode((TypedElement)target)) {
                        this.actionName = BindingUtil.makeVbl((String)FacesTargetUtilities.getTargetNodePath(target));
                    }
                    if (WebProvider.isWebPageNode((TypedElement)target)) {
                        this.pageCodeFile = CodeBehindUtil.getPageCodeFile((IFile)this.jspFile);
                        this.actionName = BindingUtil.removeVbl((String)this.actionName);
                        List<String> segs = FacesProvider.getNameSegments(this.actionName);
                        if (segs.size() > 1) {
                            this.actionName = segs.get(1);
                            FacesUtils.addActionToManagedBean(this.pageCodeFile, this.actionName, FacesCommandHelper.actionMethodContents);
                            this.addedActionToManagedBean = true;
                        }
                    }
                } else {
                    this.actionName = this.descriptor.getFromAction();
                }
                if (this.renameActionInvocation == null) {
                    this.renameActionInvocation = new RenameFacesActionInvocationResourceCommand(this.linkHandleAdapter, this.actionName, this.oldActionName, this.index, false);
                    this.renameActionInvocation.execute(progressMonitor, info);
                    if (!this.renameActionInvocation.getCommandResult().getStatus().isOK()) {
                        return this.renameActionInvocation.getCommandResult();
                    }
                    this.renamedActionInvocation = true;
                } else {
                    this.renameActionInvocation.redo(progressMonitor, info);
                    this.renamedActionInvocation = true;
                }
            }
        }
        if (!this.updatedFacesLink && !this.renamedActionInvocation) return CommandResult.newOKCommandResult();
        this.updateEdgePropertiesAprover.setProceed(true);
        return CommandResult.newOKCommandResult();
    }

    private int getDuplicateIndex(Item item, ILink targetHandle, ILink sourceHandle) {
        if (this.index == -2) {
            UICommandType uiType = UICommandType.LINK_TYPE;
            if ("button".equals(sourceHandle.getParameter("uikind"))) {
                uiType = UICommandType.BUTTON_TYPE;
            }
            this.index = FacesProvider.getDuplicateIndex(item, targetHandle, uiType);
        }
        return this.index;
    }

    private IFile getJspFile() {
        if (this.jspFile == null) {
            this.jspFile = WebProvider.getFileForNode((MNode)this.getItemFromAdapter().getNode());
        }
        return this.jspFile;
    }

    public void dispose() {
        if (this.renameActionInvocation != null) {
            this.renameActionInvocation.dispose();
        }
        super.dispose();
    }

    private ILink getHandle() {
        ILink handle = (ILink)this.linkHandleAdapter.getAdapter(ILink.class);
        return handle;
    }

    private String getCurrentTarget() {
        return AbstractWebProvider.trimQuotes((String)this.getHandle().getLinkText());
    }

    public ResourceTree getDeletionTree() {
        if (this.targetAdapter.getTargetPath().equals("")) {
            ResourceDescriptor desc = new ResourceDescriptor((Object)this.getHandle());
            desc.setDisplayText(NLS.bind((String)ResourceHandler.UpdateFileXRemoveReferenceToX, (Object)this.getFileToModify().getLocation().lastSegment(), (Object)this.getCurrentTarget()));
            return new ResourceTree(desc);
        }
        return null;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteResourceModification(progressMonitor, info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (!this.thisAprover.isProceed()) {
            return CommandResult.newOKCommandResult();
        }
        if (this.updatedFacesLink) {
            try {
                FacesTargetUtilities.updateFacesLink(this.index, this.jspFile, this.path, this.tagName, this.oldActionName);
            }
            catch (Exception e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
            this.updatedFacesLink = false;
        }
        if (this.addedActionToManagedBean) {
            FacesUtils.removeManagedBeanAction(this.pageCodeFile, this.actionName);
            this.addedActionToManagedBean = false;
        }
        if (this.renamedActionInvocation) {
            this.renameActionInvocation.undo(progressMonitor, info);
            this.renamedActionInvocation = false;
        }
        return CommandResult.newOKCommandResult();
    }
}

