/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.model2.diagram.faces.internal.FacesChangeCommand;
import com.ibm.etools.references.web.faces.FacesNavigation;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;

public class RenameOutcomeItemResourceCommand
extends AbstractCommand {
    private final Item item;
    private final String newOutcome;
    private FacesChangeCommand facesChangeCommand;

    public RenameOutcomeItemResourceCommand(String label, Item item, String newOutcome) {
        super(label, Collections.EMPTY_LIST);
        this.item = item;
        this.newOutcome = "".equals(newOutcome) ? null : newOutcome;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        final FacesNavigation caseHandle = (FacesNavigation)this.item.getAdapter(FacesNavigation.class);
        FacesChangeCommand.FacesChanges changes = new FacesChangeCommand.FacesChanges(){

            @Override
            protected boolean doFacesChanges(FacesConfigType facesConfig) {
                NavigationCaseType navCase = caseHandle.getNavigationCase(facesConfig);
                if (navCase.getFromOutcome() == null && RenameOutcomeItemResourceCommand.this.newOutcome != null) {
                    FromOutcomeType fromOutcome = FacesConfigFactory.eINSTANCE.createFromOutcomeType();
                    fromOutcome.setTextContent(RenameOutcomeItemResourceCommand.this.newOutcome);
                    navCase.setFromOutcome(fromOutcome);
                } else if (RenameOutcomeItemResourceCommand.this.newOutcome == null) {
                    navCase.setFromOutcome(null);
                } else {
                    navCase.getFromOutcome().setTextContent(RenameOutcomeItemResourceCommand.this.newOutcome);
                }
                return true;
            }
        };
        this.facesChangeCommand = FacesChangeCommand.getFacesCommand(caseHandle.getFacesConfigFile(), changes, true);
        this.facesChangeCommand.execute();
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.facesChangeCommand != null && this.facesChangeCommand.canUndo()) {
            this.facesChangeCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }

    public void dispose() {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.dispose();
        }
        super.dispose();
    }
}

