/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.resource.cmds;

import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigSchemeUtil;
import com.ibm.etools.model2.diagram.faces.internal.FacesChangeCommand;
import com.ibm.etools.model2.diagram.faces.internal.edithelper.cmds.NavRuleDescriptor;
import com.ibm.etools.model2.diagram.faces.internal.edithelper.cmds.TargetNodeAdapter;
import com.ibm.etools.model2.diagram.faces.internal.edithelper.nodes.FacesCommandHelper;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import com.ibm.etools.references.web.faces.FacesNavigation;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FromActionType;
import org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class CreateNavigationRuleCommand
extends AbstractCommand {
    private final IFile facesConfigFile;
    private FacesChangeCommand facesChangeCommand;
    private final NavRuleDescriptor descriptor;
    private final TargetNodeAdapter targetNodeAdapter;
    private final CommandExecutionAprover createAprover;

    public CreateNavigationRuleCommand(IFile facesConfigFile, TargetNodeAdapter targetNodeAdapter, NavRuleDescriptor descriptor, CommandExecutionAprover createAprover) {
        super(ResourceHandler.CreateNavigationRule, Collections.singletonList(facesConfigFile));
        this.facesConfigFile = facesConfigFile;
        this.targetNodeAdapter = targetNodeAdapter;
        this.descriptor = descriptor;
        this.createAprover = createAprover;
    }

    private String getToView() {
        String toView = this.targetNodeAdapter.getTargetPath();
        toView = FacesLinkUtil.addLeadingSlash((String)toView);
        return toView;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (!this.createAprover.isProceed()) {
            return CommandResult.newOKCommandResult();
        }
        if (this.facesConfigFile == null) {
            return null;
        }
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.dispose();
        }
        String fromView = this.descriptor.getFromView();
        FacesConfigArtifactEdit edit = null;
        if (fromView == null || "".equals(fromView)) {
            edit = FacesConfigSchemeUtil.getFacesConfigArtifactEditGlobalNavRulesForWrite((IResource)this.facesConfigFile);
        }
        FacesChangeCommand.FacesChanges changes = new FacesChangeCommand.FacesChanges(){

            @Override
            protected boolean doFacesChanges(FacesConfigType facesConfig) {
                String fromView = CreateNavigationRuleCommand.this.descriptor.getFromView();
                List navigations = FacesLinkUtil.getAllFacesNavigation((IResource)CreateNavigationRuleCommand.this.facesConfigFile, null);
                if (fromView == null) {
                    navigations = FacesLinkUtil.applicableToFromViews((String)fromView, (List)navigations);
                } else {
                    Iterator iterator = navigations.iterator();
                    while (iterator.hasNext()) {
                        FacesNavigation facesNavigation = (FacesNavigation)iterator.next();
                        if (facesNavigation.navRule != null && fromView.equals(facesNavigation.navRule.getLinkText())) continue;
                        iterator.remove();
                    }
                }
                NavigationRuleType navRule = null;
                if (navigations.isEmpty()) {
                    navRule = FacesConfigFactory.eINSTANCE.createNavigationRuleType();
                } else {
                    FacesNavigation navigation = (FacesNavigation)navigations.iterator().next();
                    navRule = (NavigationRuleType)FacesLinkUtil.getCorrespondingEObject((EClass)FacesConfigPackage.eINSTANCE.getNavigationRuleType(), (EObject)facesConfig, (ILink)navigation.navRule);
                    if (navRule == null) {
                        navRule = FacesConfigFactory.eINSTANCE.createNavigationRuleType();
                    }
                }
                NavigationCaseType navCase = FacesConfigFactory.eINSTANCE.createNavigationCaseType();
                String fromOutcome = CreateNavigationRuleCommand.this.descriptor.getOutcome();
                String fromAction = CreateNavigationRuleCommand.this.descriptor.getFromAction();
                if (fromOutcome == null || fromOutcome.length() == 0) {
                    List navs = FacesLinkUtil.getAllFacesNavigation((IResource)CreateNavigationRuleCommand.this.facesConfigFile.getParent(), null);
                    navs = FacesLinkUtil.applicableToFromViews((String)fromView, (List)navs);
                    navs = FacesLinkUtil.applicableToAction((String)fromAction, (List)navs);
                    fromOutcome = FacesCommandHelper.createUniqueOutcomeName(CreateNavigationRuleCommand.this.facesConfigFile.getProject(), navs);
                }
                if (fromView != null && !"".equals(fromView)) {
                    FromViewIdType fromViewId = FacesConfigFactory.eINSTANCE.createFromViewIdType();
                    fromViewId.setTextContent(fromView);
                    navRule.setFromViewId(fromViewId);
                }
                if (fromAction != null) {
                    fromAction = BindingUtil.makeVbl((String)fromAction);
                    FromActionType fromActionType = FacesConfigFactory.eINSTANCE.createFromActionType();
                    fromActionType.setTextContent(fromAction);
                    navCase.setFromAction(fromActionType);
                    CreateNavigationRuleCommand.this.descriptor.setFromAction(fromAction);
                }
                if (fromOutcome != null) {
                    FromOutcomeType fromOutcometype = FacesConfigFactory.eINSTANCE.createFromOutcomeType();
                    fromOutcometype.setTextContent(fromOutcome);
                    navCase.setFromOutcome(fromOutcometype);
                    CreateNavigationRuleCommand.this.descriptor.setOutcome(fromOutcome);
                }
                ToViewIdType toViewId = FacesConfigFactory.eINSTANCE.createToViewIdType();
                toViewId.setTextContent(CreateNavigationRuleCommand.this.getToView());
                navCase.setToViewId(toViewId);
                navRule.getNavigationCase().add((Object)navCase);
                facesConfig.getNavigationRule().add((Object)navRule);
                return true;
            }
        };
        this.facesChangeCommand = edit == null ? FacesChangeCommand.getFacesCommand(this.facesConfigFile, changes, true) : FacesChangeCommand.getFacesCommand(edit, changes, true);
        this.facesChangeCommand.execute();
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.facesChangeCommand != null && this.facesChangeCommand.canUndo()) {
            this.facesChangeCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }

    public void dispose() {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.dispose();
        }
        super.dispose();
    }
}

