/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.references;

import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.model2.diagram.web.internal.WDEEditingDomainManager;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.IReferenceGeneratorProvider;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.faces.FacesReferenceUtil;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;

public class DiagramFacesReferenceGenerator
implements IReferenceGeneratorProvider {
    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        IFile container = (IFile)params.reference.getSource().getContainer().getResource();
        List resources = WDEEditingDomainManager.INSTANCE.getModelRoots();
        for (Resource resource : resources) {
            IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
            if (!container.equals((Object)file)) continue;
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        if ("jdt.reference".equals(referenceType)) {
            return Collections.emptyList();
        }
        if ("wdeFacesOutcome".equals(link.getSpecializedType().getId())) {
            String trimmed = AbstractWebProvider.trimQuotes((String)link.getLinkText());
            TextRange range = AbstractWebProvider.createTrimmedRange((ILink)link, (String)trimmed);
            Reference reference = new Reference(link, "jsf.outcome");
            reference.setFragmentLocation(range);
            return Collections.singletonList(reference);
        }
        if ("wdeFacesAction".equals(link.getSpecializedType().getId())) {
            return FacesReferenceUtil.createFacesActionReferences((ILink)link, (String)referenceType, (String)transformResult);
        }
        return Collections.emptyList();
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        String link = AbstractWebProvider.trimQuotes((String)params.reference.getSource().getLinkText());
        String noVBL = BindingUtil.removeVbl((String)link);
        String[] split = noVBL.split("\\.");
        if (split.length == 2) {
            return (String)params.renameParameters.get("methodName.id");
        }
        return null;
    }
}

