/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.refactoring;

import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.model2.diagram.faces.internal.refactoring.ResourceVisitor;
import com.ibm.etools.model2.diagram.web.internal.WDEEditingDomainManager;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.refactoring.DiagramChange;
import com.ibm.etools.references.management.ReferenceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class DiagramFacesRenameParticipant
extends RenameParticipant
implements ISharableParticipant {
    private final List<ObjectAndArgs> argsList = new ArrayList<ObjectAndArgs>();

    public void addElement(Object element, RefactoringArguments arguments) {
        ObjectAndArgs args = new ObjectAndArgs();
        args.args = (RenameArguments)arguments;
        args.element = element;
        this.argsList.add(args);
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (ObjectAndArgs info : this.argsList) {
            try {
                if (!info.args.getUpdateReferences()) continue;
                IResource r = (IResource)info.element;
                if (r instanceof IFile) {
                    IFile file = (IFile)r;
                    IFile targetFile = r.getParent().getFile((IPath)new Path(info.args.getNewName()));
                    IContainer container = targetFile.getParent();
                    changes.addAll(this.renameFile(pm, (IResource)file, container, file, targetFile));
                    continue;
                }
                if (!(r instanceof IFolder)) continue;
                IFolder anchorContainer = (IFolder)r;
                IPath anchorPath = anchorContainer.getFullPath();
                IFolder newContainer = anchorContainer.getParent().getFolder((IPath)new Path(info.args.getNewName()));
                IPath newContainerPath = newContainer.getFullPath();
                ResourceVisitor children = new ResourceVisitor();
                anchorContainer.accept((IResourceVisitor)children);
                Collection<IResource> allChildren = children.getChildren();
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)pm, (int)allChildren.size());
                for (IResource resource : allChildren) {
                    IPath targetPath = resource.getFullPath();
                    int strippedSegments = targetPath.matchingFirstSegments(anchorPath);
                    targetPath = targetPath.removeFirstSegments(strippedSegments);
                    targetPath = newContainerPath.append(targetPath);
                    IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath);
                    if (resource instanceof IFile) {
                        changes.addAll(this.renameFile((IProgressMonitor)mon.newChild(1), (IResource)anchorContainer, (IContainer)newContainer, (IFile)resource, targetFile));
                        continue;
                    }
                    mon.worked(1);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (changes.isEmpty()) {
            return null;
        }
        CompositeChange change = new CompositeChange(ResourceHandler.DiagramFacesRenameParticipant_DiagramChanges, changes.toArray(new Change[changes.size()]));
        return change;
    }

    private List<Change> renameFile(IProgressMonitor monitor, IResource originalContainer, IContainer newContainer, IFile sourceFile, IFile targetFile) throws ReferenceException {
        ArrayList<Change> changes = new ArrayList<Change>();
        List resources = WDEEditingDomainManager.INSTANCE.getModelRoots();
        for (Resource resource : resources) {
            TreeIterator itr = resource.getAllContents();
            while (itr.hasNext()) {
                DiagramChange change;
                IPath newPath;
                HashMap<String, String> map;
                IPath source;
                String path;
                EObject object = (EObject)itr.next();
                if (!"http://www.ibm.com/etools/7.0/DiagramModel".equals(object.eClass().getEPackage().getNsURI()) || !(object instanceof MEdge)) continue;
                MEdge edge = (MEdge)object;
                if (FacesProvider.isPageGlobalEdge((TypedElement)edge)) {
                    path = WebProvider.getStringProperty((String)"web.edgename.key", (IPropertyHolder)edge);
                    source = WebProvider.getDocumentRootRelativePath((IFile)sourceFile);
                    if (!source.equals((Object)path)) continue;
                    map = new HashMap<String, String>();
                    newPath = WebProvider.getDocumentRootRelativePath((IFile)targetFile);
                    map.put("web.path.key", newPath.toString());
                    change = new DiagramChange((IPropertyHolder)edge, map);
                    changes.add((Change)change);
                    continue;
                }
                if (!FacesProvider.isActionOutcomeEdge((TypedElement)edge)) continue;
                path = WebProvider.getStringProperty((String)"faces.action.outcome.edge.fromview", (IPropertyHolder)edge);
                source = WebProvider.getDocumentRootRelativePath((IFile)sourceFile);
                if (!source.equals((Object)path)) continue;
                map = new HashMap();
                newPath = WebProvider.getDocumentRootRelativePath((IFile)targetFile);
                map.put("faces.action.outcome.edge.fromview", newPath.toString());
                change = new DiagramChange((IPropertyHolder)edge, map);
                changes.add((Change)change);
            }
        }
        return changes;
    }

    public String getName() {
        return ResourceHandler.DiagramFacesRenameParticipant_UpdateWebDiagramEditor;
    }

    protected boolean initialize(Object element) {
        ObjectAndArgs args = new ObjectAndArgs();
        args.args = this.getArguments();
        args.element = element;
        this.argsList.add(args);
        return true;
    }

    private class ObjectAndArgs {
        public Object element;
        public RenameArguments args;

        private ObjectAndArgs() {
        }
    }
}

