/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.providers.migration;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.IMigrationProvider;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class FacesMigrationProvider
extends FacesProvider
implements IMigrationProvider {
    public void migrateElement(CommonElement element, String oldVersion) {
        if ("com.ibm.etools.model2.faces.graphical.providers.model.ActionModelProvider".equals(element.getType())) {
            element.setType("com.ibm.etools.model2.diagram.faces.FacesActionNode");
        } else if ("com.ibm.etools.model2.faces.graphical.providers.edge.FacesActionRefEdgeProvider".equals(element.getType())) {
            element.setType("com.ibm.etools.model2.diagram.faces.FacesActionInvocationEdge");
        } else if ("com.ibm.etools.model2.faces.graphical.providers.edge.FacesOutcomeEdgeProvider".equals(element.getType())) {
            element.setType("com.ibm.etools.model2.diagram.faces.FacesActionOutcomeEdge");
        }
    }

    public void postProcessDiagram(Diagram diagram, String oldVersion) {
        MDiagram semantic = (MDiagram)diagram.getElement();
        if (semantic != null) {
            EList nodes = semantic.getNodes();
            for (MNode node : nodes) {
                if (!FacesProvider.isFacesActionNode((TypedElement)node)) continue;
                WebProvider.renamePropertyName((String)"faces.action.name", (String)"faces.action.node.name", (IPropertyHolder)node);
                WebProvider.makeTitleProperty((String)"faces.action.node.name", (IPropertyHolder)node);
                Property property = WebProvider.getFirstProperty((String)"faces.action.node.name", (IPropertyHolder)node);
                if (property != null) {
                    property.setEditable(true);
                } else {
                    property = DiagramModelFactory.eINSTANCE.createProperty();
                    property.setName("faces.action.node.name");
                    property.setValue("");
                    node.getPersistedProperties().add((Object)property);
                }
                WebProvider.deleteStringProperty((String)"hidden", (IPropertyHolder)node);
            }
            EList edges = semantic.getModel().getEdges();
            boolean warnUser = false;
            for (MEdge edge : edges) {
                MNode source = edge.getSource();
                MNode target = edge.getTarget();
                if (FacesProvider.isActionInvocationEdge((TypedElement)edge)) {
                    Property edgeProperty = DiagramModelFactory.eINSTANCE.createProperty();
                    edgeProperty.setName("faces.action.invocation.edge.action.key");
                    edgeProperty.setValue(WebProvider.getStringProperty((String)"faces.action.node.name", (IPropertyHolder)target));
                    edge.getPersistedProperties().add((Object)edgeProperty);
                    WebProvider.deleteStringProperty((String)"hidden", (IPropertyHolder)edge);
                    continue;
                }
                if (!FacesProvider.isActionOutcomeEdge((TypedElement)edge)) continue;
                if (WebProvider.isWebPageNode((TypedElement)source)) {
                    edge.setType("com.ibm.etools.model2.diagram.faces.PageNavigationEdge");
                    WebProvider.renamePropertyName((String)"Faces Outcome Name", (String)"pagecode.outcome.edge.outcome.key", (IPropertyHolder)edge);
                    warnUser = true;
                } else {
                    WebProvider.renamePropertyName((String)"Faces Outcome Name", (String)"faces.action.outcome.edge.outcome", (IPropertyHolder)edge);
                    warnUser = true;
                }
                WebProvider.deleteStringProperty((String)"hidden", (IPropertyHolder)edge);
            }
            if (warnUser) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MessageBox box = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 32);
                        box.setText(ResourceHandler.FacesMigrationProvider_9);
                        box.setMessage(ResourceHandler.FacesMigrationProvider_10);
                        box.open();
                    }
                };
                PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
            }
        }
    }
}

