/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.providers.config;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.SubItem;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.IConfiguratorProvider;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.EdgeResolverService;
import com.ibm.etools.model2.diagram.faces.internal.DiagramFacesConstants;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.faces.FacesAction;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public class FacesActionNodeConfiguratorProvider
extends FacesProvider
implements IConfiguratorProvider {
    public void configureNew(CommonElement element) {
        String newPath = "bean";
        int increment = 1;
        MNode nodeToConfigure = (MNode)element;
        while (!this.isUniqueName(nodeToConfigure, newPath, increment, ".action")) {
            ++increment;
        }
        Property property = DiagramModelFactory.eINSTANCE.createProperty();
        property.setName("faces.action.node.name");
        property.setValue(this.createName(newPath, increment, ".action"));
        property.setEditable(true);
        element.getPersistedProperties().add((Object)property);
        Property filterFromVIew = DiagramModelFactory.eINSTANCE.createProperty();
        filterFromVIew.setName(DiagramFacesConstants.FACES_ACTION_FILTER_FROMVIEWID);
        filterFromVIew.setValue("true");
        filterFromVIew.setEditable(true);
        element.getPersistedProperties().add((Object)filterFromVIew);
        element.setTitleProperty(property);
        this.addTransientProperties(element);
    }

    public void configureLoad(CommonElement element) {
        String property = WebProvider.getStringProperty((String)DiagramFacesConstants.FACES_ACTION_FILTER_FROMVIEWID, (IPropertyHolder)element);
        if (property == null || property.length() == 0) {
            Property filterFromVIew = DiagramModelFactory.eINSTANCE.createProperty();
            filterFromVIew.setName(DiagramFacesConstants.FACES_ACTION_FILTER_FROMVIEWID);
            filterFromVIew.setValue("true");
            filterFromVIew.setEditable(true);
            element.getPersistedProperties().add((Object)filterFromVIew);
        }
        this.addTransientProperties(element);
    }

    public void addTransientProperties(CommonElement element) {
    }

    public void configureExisting(CommonElement element, Object existing, Map options) {
        FacesAction handle;
        String actionPath = null;
        if (existing instanceof IAdaptable) {
            handle = null;
            handle = (FacesAction)((IAdaptable)existing).getAdapter(FacesAction.class);
            actionPath = handle.getBeanActionName();
        } else if (existing instanceof FacesAction) {
            handle = null;
            handle = (FacesAction)existing;
            actionPath = handle.getBeanActionName();
        } else if (existing instanceof String) {
            actionPath = (String)existing;
        }
        MNode node = (MNode)element;
        if (actionPath != null && "nodePhase".equals(options.get("configure phase"))) {
            Object property;
            boolean updatedName = WebProvider.updateStringProperty((String)"faces.action.node.name", (String)actionPath, (IPropertyHolder)node);
            if (!updatedName) {
                property = DiagramModelFactory.eINSTANCE.createProperty();
                property.setName("faces.action.node.name");
                property.setValue(actionPath);
                property.setEditable(true);
                element.getPersistedProperties().add(property);
                element.setTitleProperty((Property)property);
            }
            if ((property = WebProvider.getStringProperty((String)DiagramFacesConstants.FACES_ACTION_FILTER_FROMVIEWID, (IPropertyHolder)element)) == null || ((String)property).length() == 0) {
                Property filterFromVIew = DiagramModelFactory.eINSTANCE.createProperty();
                filterFromVIew.setName(DiagramFacesConstants.FACES_ACTION_FILTER_FROMVIEWID);
                filterFromVIew.setValue("true");
                filterFromVIew.setEditable(true);
                element.getPersistedProperties().add((Object)filterFromVIew);
            }
        }
        if ("edgePhase".equals(options.get("configure phase")) && Boolean.TRUE.equals(options.get("use defaults"))) {
            ArrayList<MNode> nodes = new ArrayList<MNode>((Collection<MNode>)node.getParent().getNodes());
            nodes.remove(node);
            EList compartments = node.getCompartments();
            for (Compartment compartment : compartments) {
                EList items = compartment.getItems();
                for (NodeItem nodeItem : items) {
                    this.processItem(options, node, nodes, (Item)nodeItem);
                    EList subItems = nodeItem.getChildren();
                    for (SubItem subItem : subItems) {
                        this.processItem(options, node, nodes, (Item)subItem);
                    }
                }
            }
        }
    }

    private void processItem(Map<String, List> options, MNode node, List<MNode> nodes, Item nodeItem) {
        List list = EdgeGeneratorService.getInstance().getGenerableEdgeTypes(nodeItem);
        for (IElementType edgeType : list) {
            List references = EdgeGeneratorService.getInstance().generateExistingReferences(nodeItem, edgeType, nodeItem.getElementType());
            for (SourceReference reference : references) {
                for (MNode otherNode : nodes) {
                    IElementType otherNodeType = otherNode.getElementType();
                    List resolvableEdgeTypes = EdgeResolverService.getInstance().getResolvableEdgeTypes(otherNodeType);
                    if (!resolvableEdgeTypes.contains(edgeType) || !EdgeResolverService.getInstance().isResolvable(otherNode, reference)) continue;
                    List outputs = EdgeGeneratorService.getInstance().getItemsEdges(nodeItem);
                    boolean foundMatch = false;
                    for (MEdge edge : outputs) {
                        if (!otherNode.equals(edge.getTarget()) || !edgeType.getId().equals(edge.getType())) continue;
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    CreateRelationshipRequest req = new CreateRelationshipRequest((EObject)node.getParent().getModel(), (EObject)node, (EObject)otherNode, edgeType);
                    IElementType webDiagramType = node.getParent().getElementType();
                    req.addParameters(options);
                    req.setParameter("existing edge", (Object)Boolean.TRUE);
                    req.setParameter("source reference", (Object)reference);
                    ICommand cmd = webDiagramType.getEditCommand((IEditCommandRequest)req);
                    if (!cmd.canExecute()) continue;
                    try {
                        cmd.execute(null, null);
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private boolean isUniqueName(MNode nodeToConfigure, String beanName, int intsuffix, String actionName) {
        MDiagram d = nodeToConfigure.getParent();
        String incedPath = this.createName(beanName, intsuffix, actionName);
        EList nodes = d.getNodes();
        for (MNode node : nodes) {
            String nodePath;
            if (!FacesActionNodeConfiguratorProvider.isFacesActionNode((TypedElement)node) || !incedPath.equals(nodePath = FacesActionNodeConfiguratorProvider.getStringProperty((String)"faces.action.node.name", (IPropertyHolder)node))) continue;
            return false;
        }
        String justBeanName = this.createName(beanName, intsuffix, null);
        Collection managedBeanHandles = FacesLinkUtil.getAllFacesManagedBeans((IProject)FacesProvider.getProjectForElement((CommonElement)nodeToConfigure), (boolean)true, null);
        for (ILink managedBean : managedBeanHandles) {
            if (!justBeanName.equals(managedBean.getName())) continue;
            return false;
        }
        return true;
    }

    private String createName(String beanName, int intSuffix, String actionName) {
        if (actionName == null) {
            actionName = "";
        }
        if (intSuffix > 0) {
            return String.valueOf(beanName) + intSuffix + actionName;
        }
        return String.valueOf(beanName) + actionName;
    }
}

