/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.edithelper.nodes;

import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.preferences.JsfTagModeUtil;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.WebDiagramCommandHelper;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import com.ibm.etools.references.web.faces.FacesNavigation;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.model.util.ModelUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class FacesCommandHelper {
    public static final String HX_URI = "http://www.ibm.com/jsf/html_extended";
    public static final String COMMAND_EX_BUTTON = "commandExButton";
    public static final String H_URI = "http://java.sun.com/jsf/html";
    public static final String COMMAND_BUTTON = "commandButton";
    public static final String ACTION_ATTRIB = "action";
    public static final String OUTPUT_LINK = "outputLinkEx";
    public static final String VALUE_ATTRIB = "value";
    public static final String REQUEST_LINK = "requestLink";
    private static String button;
    private static String uri;
    public static String actionMethodContents;

    static {
        actionMethodContents = "boolean condition=true;if(condition){\treturn \"" + ResourceHandler.Success + "\"; " + "}" + "return \"" + ResourceHandler.Failure + "\"; ";
    }

    public static String getButton(IProject project) {
        button = COMMAND_EX_BUTTON;
        if (!JsfTagModeUtil.isUsingIbmTags((IProject)project)) {
            button = COMMAND_BUTTON;
        }
        return button;
    }

    public static String getURI(IProject project) {
        uri = HX_URI;
        if (!JsfTagModeUtil.isUsingIbmTags((IProject)project)) {
            uri = H_URI;
        }
        return uri;
    }

    public static String createUniqueOutcomeName(IProject project, List<FacesNavigation> navCaseHandles) {
        boolean foundSuccess = false;
        boolean foundFailure = false;
        for (FacesNavigation caseHandle : navCaseHandles) {
            if (ResourceHandler.Success.equals(caseHandle.getFromOutcome())) {
                foundSuccess = true;
                continue;
            }
            if (!ResourceHandler.Failure.equals(caseHandle.getFromOutcome())) continue;
            foundFailure = true;
        }
        if (!foundSuccess) {
            return ResourceHandler.Success;
        }
        if (!foundFailure) {
            return ResourceHandler.Failure;
        }
        int i = 1;
        while (!FacesCommandHelper.isUniquePath(project, ResourceHandler.NewOutcome, i)) {
            ++i;
        }
        return FacesCommandHelper.createPath(ResourceHandler.NewOutcome, i);
    }

    private static boolean isUniquePath(IProject project, String newPath, int suffix) {
        String incedPath = FacesCommandHelper.createPath(newPath, suffix);
        List navigations = FacesLinkUtil.getAllFacesNavigation((IResource)project, null);
        navigations = FacesLinkUtil.applicableToEveryAction((List)navigations);
        for (FacesNavigation caseHandle : navigations) {
            String outcome = caseHandle.getFromOutcome();
            if (!outcome.equals(incedPath)) continue;
            return false;
        }
        return true;
    }

    private static String createPath(String newPath, int suffix) {
        if (suffix >= 1) {
            return String.valueOf(newPath) + suffix;
        }
        return newPath;
    }

    public static boolean updateOutputLink(IFile file, String oldPath, String newPath, int dupIndex) throws UnsupportedEncodingException, IOException, CoreException, WebModelCreationException, Exception {
        if (file != null && file.exists()) {
            HTMLEditDomain domain = null;
            try {
                domain = ModelUtil.getEditDomain((IFile)file);
                String tagName = String.valueOf(JsfCommandUtil.getPreferredPrefix((String)HX_URI, (IProject)file.getProject())) + ":" + OUTPUT_LINK;
                WebDiagramCommandHelper.updateLink((int)dupIndex, (HTMLEditDomain)domain, (String)tagName, Collections.singleton(VALUE_ATTRIB), (String)VALUE_ATTRIB, (String)oldPath, (String)newPath);
            }
            finally {
                ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
            }
        } else {
            return false;
        }
        return true;
    }
}

