/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.edithelper.cmds.nodes;

import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.model2.diagram.faces.internal.FacesUtils;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.faces.FacesAction;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RenameFacesActionNodeCommand
extends ResourceModificationCommand {
    private final MNode node;
    private final CommandExecutionAprover aprover;
    private boolean shownMessage = false;
    private boolean ok = false;
    private final String oldActionName;
    private final String newBeanName;
    private final String newActionName;
    private IProject project;
    private String className;
    private IFile file;

    public RenameFacesActionNodeCommand(SetRequest req, CommandExecutionAprover aprover) {
        super(ResourceHandler.RenameFacesAction);
        String oldAction;
        List<String> facesAction;
        this.aprover = aprover;
        this.node = (MNode)req.getElementToEdit().eContainer();
        FacesAction facesActionHandle = (FacesAction)this.node.getAdapter(FacesAction.class);
        this.oldActionName = facesActionHandle == null ? ((facesAction = FacesProvider.getNameSegments(oldAction = WebProvider.getStringProperty((String)"faces.action.node.name", (IPropertyHolder)this.node))).size() > 1 ? facesAction.get(1) : facesAction.get(0)) : facesActionHandle.getActionName();
        String newValue = (String)req.getValue();
        facesAction = FacesProvider.getNameSegments(newValue);
        if (facesAction.size() > 1) {
            this.newBeanName = facesAction.get(0);
            this.newActionName = facesAction.get(1);
        } else {
            this.newBeanName = "";
            this.newActionName = "";
        }
    }

    protected IFile getFileToModify() {
        FacesAction handle;
        if (this.file == null && (handle = (FacesAction)this.node.getAdapter(FacesAction.class)) != null) {
            return (IFile)handle.managedbean.getContainer().getResource();
        }
        return this.file;
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        FacesAction handle;
        if (!this.shownMessage) {
            this.ok = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)ResourceHandler.UpdateActionReferences, (String)ResourceHandler.WouldYouLikeToUpdateNonWildcard);
            this.shownMessage = true;
        }
        this.aprover.setProceed(this.ok);
        if (!this.isValidFacesActionName(this.newBeanName, this.newActionName)) {
            return CommandResult.newCancelledCommandResult();
        }
        if (!this.oldActionName.equals(this.newActionName) && (handle = (FacesAction)this.node.getAdapter(FacesAction.class)) != null) {
            this.className = AbstractWebProvider.trimQuotes((String)handle.managedbean.getLinkText());
            IFile file = (IFile)handle.managedbean.getContainer().getResource();
            if (file != null) {
                this.project = file.getProject();
                FacesUtils.renameManagedBeanAction(this.project, this.className, this.oldActionName, this.newActionName, progressMonitor);
                this.node.removeAdapter(FacesAction.class);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (!this.oldActionName.equals(this.newActionName) && this.className != null) {
            FacesUtils.renameManagedBeanAction(this.project, this.className, this.oldActionName, this.newActionName, progressMonitor);
            this.node.removeAdapter(FacesAction.class);
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (!this.oldActionName.equals(this.newActionName) && this.className != null) {
            FacesUtils.renameManagedBeanAction(this.project, this.className, this.newActionName, this.oldActionName, progressMonitor);
            this.node.removeAdapter(FacesAction.class);
        }
        return CommandResult.newOKCommandResult();
    }

    public void dispose() {
        super.dispose();
    }

    private boolean isValidFacesActionName(String newBeanName, String newActionName) {
        if (newBeanName.length() == 0 || newActionName.length() == 0) {
            MessageBox box = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 32);
            box.setText(ResourceHandler.InvalidRename);
            box.setMessage(ResourceHandler.FacesActionStringMustHaveTheFormat);
            box.open();
            return false;
        }
        if (!JavaConventions.validateMethodName((String)newActionName).isOK()) {
            MessageBox box = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 32);
            box.setText(ResourceHandler.InvalidRename);
            box.setMessage(ResourceHandler.TheFacesActionMustHaveValidMethodName);
            box.open();
            return false;
        }
        if (!JavaConventions.validateFieldName((String)newBeanName).isOK()) {
            MessageBox box = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 32);
            box.setText(ResourceHandler.InvalidRename);
            box.setMessage(ResourceHandler.FacesBeanNameMustBeValidField);
            box.open();
            return false;
        }
        return true;
    }
}

