/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.edithelper.cmds.nodes;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.model2.diagram.faces.internal.DiagramFacesPlugin;
import com.ibm.etools.model2.diagram.faces.internal.FacesChangeCommand;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import com.ibm.etools.references.web.faces.FacesNavigation;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.osgi.util.NLS;

public class DeleteWebPageNodeCommand
extends ResourceModificationCommand
implements IDeletionCommand {
    private final DestroyElementRequest request;
    private final List<Object> resourcesToDelete;
    private IFile facesConfig;
    private IFile javaClassFile;
    private boolean deletedActionClass = false;
    private FacesChangeCommand facesChangeCommand;
    private FacesChangeCommand facesChangeCommand2;

    public DeleteWebPageNodeCommand(String label, DestroyElementRequest request, List<Object> resourcesToDelete) {
        super(label);
        this.request = request;
        this.resourcesToDelete = resourcesToDelete;
    }

    public ResourceTree getDeletionTree() {
        ILink managedBeanHandle;
        String managedBeanName;
        MNode resource = (MNode)this.request.getElementToDestroy();
        IFile file = WebProvider.getFileForNode((MNode)resource);
        if (file == null) {
            return null;
        }
        String fileName = FacesLinkUtil.addLeadingSlash((String)file.getName());
        if (file.exists() && WebProvider.isJSP((IAdaptable)file) && (managedBeanName = CodeBehindUtil.getManagedBeanName((IFile)file)) != null && (managedBeanHandle = FacesLinkUtil.getManagedBeanLink((String)managedBeanName, (IProject)file.getProject())) != null) {
            IFile configFile = (IFile)managedBeanHandle.getContainer().getResource();
            ResourceDescriptor desc = new ResourceDescriptor((Object)configFile);
            ResourceTree tree = new ResourceTree(desc);
            desc.setDisplayText(NLS.bind((String)ResourceHandler.RemoveFacesActionXinX, (Object)managedBeanName, (Object)configFile.getProjectRelativePath().makeAbsolute().toString()));
            IFile javaClass = this.getJavaClassFile(managedBeanHandle);
            if (javaClass != null && javaClass.exists()) {
                String javaClassName = javaClass.getProjectRelativePath().makeAbsolute().toString();
                IJavaElement element = JavaCore.create((IFile)javaClass);
                javaClassName = element.getElementName();
                if (element instanceof ICompilationUnit) {
                    ICompilationUnit cu = (ICompilationUnit)element;
                    IType type = cu.findPrimaryType();
                    javaClassName = type.getFullyQualifiedName();
                }
                ResourceDescriptor desc2 = new ResourceDescriptor((Object)javaClass);
                desc2.setDisplayText(NLS.bind((String)ResourceHandler.RemoveActionClassX, (Object)javaClassName));
                tree.addChild(desc2);
            }
            List navs = FacesLinkUtil.getAllFacesNavigation((IResource)configFile, null);
            if (!(navs = FacesLinkUtil.applicableToFromViews((String)fileName, (List)navs)).isEmpty()) {
                for (FacesNavigation facesNavigation : navs) {
                    IFile facesConfig = facesNavigation.getFacesConfigFile();
                    ResourceDescriptor desc3 = new ResourceDescriptor((Object)facesConfig);
                    Object[] values = new String[]{configFile.getProjectRelativePath().makeAbsolute().toString(), facesNavigation.getFromView()};
                    desc3.setDisplayText(NLS.bind((String)ResourceHandler.DeleteFacesRuleResourceCommand_FromViewXinfileX, (Object[])values));
                    tree.addChild(desc3);
                }
            }
            return tree;
        }
        return null;
    }

    public boolean canExecute() {
        return true;
    }

    protected IFile getFileToModify() {
        MNode resource = (MNode)this.request.getElementToDestroy();
        IFile file = WebProvider.getFileForNode((MNode)resource);
        return file;
    }

    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        MNode resource = (MNode)this.request.getElementToDestroy();
        IFile file = WebProvider.getFileForNode((MNode)resource);
        String fileName = FacesLinkUtil.addLeadingSlash((String)file.getName());
        if (file.exists() && WebProvider.isJSP((IAdaptable)file)) {
            String managedBeanName = CodeBehindUtil.getManagedBeanName((IFile)file);
            if (managedBeanName == null) {
                return CommandResult.newOKCommandResult();
            }
            final ILink managedBeanHandle = FacesLinkUtil.getManagedBeanLink((String)managedBeanName, (IProject)file.getProject());
            if (managedBeanHandle == null) {
                return CommandResult.newOKCommandResult();
            }
            this.facesConfig = (IFile)managedBeanHandle.getContainer().getResource();
            if (this.facesConfig != null && this.facesConfig.exists()) {
                this.javaClassFile = this.getJavaClassFile(managedBeanHandle);
                if (this.resourcesToDelete != null && this.resourcesToDelete.contains(this.javaClassFile)) {
                    try {
                        this.javaClassFile.delete(true, true, progressMonitor);
                    }
                    catch (CoreException e) {
                        DiagramFacesPlugin.getDefault().getLog().log(e.getStatus());
                    }
                    this.deletedActionClass = true;
                }
                if (this.resourcesToDelete != null && this.resourcesToDelete.contains(this.facesConfig)) {
                    if (this.facesChangeCommand != null) {
                        this.facesChangeCommand.dispose();
                    }
                    FacesChangeCommand.FacesChanges changes = new FacesChangeCommand.FacesChanges(){

                        @Override
                        protected boolean doFacesChanges(FacesConfigType facesConfig) {
                            ManagedBeanType type = (ManagedBeanType)FacesLinkUtil.getCorrespondingEObject((EClass)FacesConfigPackage.eINSTANCE.getManagedBeanType(), (EObject)facesConfig, (ILink)managedBeanHandle);
                            facesConfig.getManagedBean().remove((Object)type);
                            return true;
                        }
                    };
                    this.facesChangeCommand = FacesChangeCommand.getFacesCommand(this.facesConfig, changes, true);
                    this.facesChangeCommand.execute();
                    if (this.facesChangeCommand2 != null) {
                        this.facesChangeCommand2.dispose();
                    }
                    List navs = FacesLinkUtil.getAllFacesNavigation((IResource)this.facesConfig, null);
                    final List tmpFinal = navs = FacesLinkUtil.applicableToFromViews((String)fileName, (List)navs);
                    if (!navs.isEmpty()) {
                        FacesChangeCommand.FacesChanges changes2 = new FacesChangeCommand.FacesChanges(){

                            @Override
                            protected boolean doFacesChanges(FacesConfigType facesConfig) {
                                ArrayList<NavigationRuleType> types = new ArrayList<NavigationRuleType>();
                                for (FacesNavigation facesNavigation : tmpFinal) {
                                    NavigationRuleType type = facesNavigation.getNavigationRule(facesConfig);
                                    if (type == null) continue;
                                    types.add(type);
                                }
                                facesConfig.getNavigationRule().removeAll(types);
                                return true;
                            }
                        };
                        this.facesChangeCommand2 = FacesChangeCommand.getFacesCommand(this.facesConfig, changes2, true);
                        this.facesChangeCommand2.execute();
                    }
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult(progressMonitor, info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.deletedActionClass) {
            try {
                IFileState[] state = this.javaClassFile.getHistory(progressMonitor);
                if (state != null && state.length > 0) {
                    this.javaClassFile.create(state[0].getContents(), false, progressMonitor);
                    this.deletedActionClass = false;
                }
                Debug.noop();
            }
            catch (CoreException e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        if (this.facesChangeCommand != null && this.facesChangeCommand.canUndo()) {
            this.facesChangeCommand.undo();
        }
        if (this.facesChangeCommand2 != null && this.facesChangeCommand2.canUndo()) {
            this.facesChangeCommand2.undo();
        }
        return CommandResult.newOKCommandResult();
    }

    private IFile getJavaClassFile(ILink beanHandle) {
        ILink javaTarget = FacesLinkUtil.getJavaTarget((ILink)beanHandle);
        if (javaTarget != null) {
            return (IFile)javaTarget.getContainer().getResource();
        }
        return null;
    }

    public void dispose() {
        if (this.facesChangeCommand2 != null) {
            this.facesChangeCommand2.dispose();
        }
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.dispose();
        }
        super.dispose();
    }
}

