/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal.edithelper.cmds.nodes;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.model2.diagram.faces.internal.DiagramFacesPlugin;
import com.ibm.etools.model2.diagram.faces.internal.FacesChangeCommand;
import com.ibm.etools.model2.diagram.faces.internal.FacesUtils;
import com.ibm.etools.model2.diagram.faces.internal.edithelper.nodes.FacesCommandHelper;
import com.ibm.etools.model2.diagram.faces.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.model2.diagram.faces.internal.resource.cmds.items.DeleteNavigationCaseResourceCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.faces.FacesAction;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.osgi.util.NLS;

public class DeleteFacesActionNodeCommand
extends AbstractCommand
implements IDeletionCommand {
    private final List<Object> resourcesToDelete;
    private final MNode node;
    private boolean deletedActionClass = false;
    private boolean deletedActionMethod = false;
    private IFile javaClassFile;
    private IFile facesConfig;
    private ILink beanHandle;
    private FacesAction actionHandle;
    private CompositeCommand deleteFacesActionFromViewsCommand;
    private FacesChangeCommand facesChangeCommand;
    private final Map<String, MNode> selectedMethods;

    public DeleteFacesActionNodeCommand(String label, MNode node, List<Object> resourcesToDelete, List<Object> selectedNodes) {
        super(label);
        this.node = node;
        this.resourcesToDelete = resourcesToDelete;
        this.selectedMethods = new HashMap<String, MNode>();
        FacesAction actionToDeleteHandle = (FacesAction)this.getNode().getAdapter(FacesAction.class);
        if (selectedNodes != null && actionToDeleteHandle != null) {
            for (Object n : selectedNodes) {
                FacesAction selectedActionHandle;
                MNode selectedNode;
                if (!(n instanceof MNode) || !FacesProvider.isFacesActionNode((TypedElement)(selectedNode = (MNode)n)) || (selectedActionHandle = (FacesAction)selectedNode.getAdapter(FacesAction.class)) == null || !actionToDeleteHandle.getBeanName().equals(selectedActionHandle.getBeanName())) continue;
                this.selectedMethods.put(selectedActionHandle.getActionName(), selectedNode);
            }
        }
    }

    private CommandResult deleteFacesAction(IProgressMonitor progressMonitor) throws ExecutionException {
        this.actionHandle = (FacesAction)this.getNode().getAdapter(FacesAction.class);
        if (this.actionHandle != null) {
            this.beanHandle = this.actionHandle.managedbean;
            if (this.beanHandle != null) {
                this.facesConfig = (IFile)this.beanHandle.getContainer().getResource();
                if (this.facesConfig != null && this.facesConfig.exists()) {
                    block13: {
                        this.javaClassFile = this.getJavaClassFile(this.actionHandle);
                        if (this.resourcesToDelete != null) {
                            IJavaProject jp = JavaCore.create((IProject)FacesProvider.getProjectForElement((CommonElement)this.getNode()));
                            String clazz = AbstractWebProvider.trimQuotes((String)this.beanHandle.getLinkText());
                            try {
                                IType t = jp.findType(clazz);
                                IMethod method = t.getMethod(this.actionHandle.getActionName(), new String[0]);
                                if (this.resourcesToDelete.contains(this.beanHandle)) {
                                    if (this.resourcesToDelete.contains(this.javaClassFile)) {
                                        try {
                                            this.javaClassFile.delete(true, true, progressMonitor);
                                            this.getNode().removeAdapter(FacesAction.class);
                                            this.deletedActionClass = true;
                                        }
                                        catch (CoreException e) {
                                            DiagramFacesPlugin.getDefault().getLog().log(e.getStatus());
                                        }
                                    }
                                    if (this.facesChangeCommand != null) {
                                        this.facesChangeCommand.dispose();
                                    }
                                    FacesChangeCommand.FacesChanges changes = new FacesChangeCommand.FacesChanges(){

                                        @Override
                                        protected boolean doFacesChanges(FacesConfigType facesConfig) {
                                            EList beans = facesConfig.getManagedBean();
                                            String beanName = DeleteFacesActionNodeCommand.this.beanHandle.getName();
                                            ManagedBeanType type = DeleteFacesActionNodeCommand.this.getManageBean((EList<ManagedBeanType>)beans, beanName);
                                            facesConfig.getManagedBean().remove((Object)type);
                                            return true;
                                        }
                                    };
                                    this.facesChangeCommand = FacesChangeCommand.getFacesCommand((IFile)this.beanHandle.getContainer().getResource(), changes, true);
                                    this.facesChangeCommand.execute();
                                    break block13;
                                }
                                if (this.resourcesToDelete.contains(method) && method.exists()) {
                                    FacesUtils.removeManagedBeanAction(this.javaClassFile, this.actionHandle.getActionName());
                                    this.deletedActionMethod = true;
                                }
                            }
                            catch (JavaModelException e) {
                                DiagramFacesPlugin.getDefault().getLog().log(e.getStatus());
                            }
                        }
                    }
                    this.deleteFacesActionFromViewsCommand = this.getDeleteFromViewsCommand();
                    this.deleteFacesActionFromViewsCommand.execute(progressMonitor, null);
                    if (!this.deleteFacesActionFromViewsCommand.getCommandResult().getStatus().isOK()) {
                        return this.deleteFacesActionFromViewsCommand.getCommandResult();
                    }
                }
            }
        }
        return null;
    }

    public void dispose() {
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.dispose();
        }
        if (this.deleteFacesActionFromViewsCommand != null) {
            this.deleteFacesActionFromViewsCommand.dispose();
        }
        super.dispose();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = this.deleteFacesAction(progressMonitor);
        if (result != null) {
            return result;
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.deletedActionMethod) {
            IJavaProject jp = JavaCore.create((IProject)FacesProvider.getProjectForElement((CommonElement)this.getNode()));
            try {
                String clazz = this.beanHandle.getLinkText();
                IType t = jp.findType(clazz);
                IMethod method = t.getMethod(this.actionHandle.getActionName(), new String[0]);
                if (method.exists()) {
                    FacesUtils.removeManagedBeanAction(this.javaClassFile, this.actionHandle.getActionName());
                    this.deletedActionMethod = true;
                }
            }
            catch (JavaModelException e) {
                DiagramFacesPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        if (this.deletedActionClass) {
            this.getNode().removeAdapter(FacesAction.class);
            try {
                this.javaClassFile.delete(true, true, progressMonitor);
            }
            catch (CoreException e) {
                DiagramFacesPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        if (this.facesChangeCommand != null) {
            this.facesChangeCommand.redo();
        }
        if (this.deleteFacesActionFromViewsCommand != null) {
            this.deleteFacesActionFromViewsCommand.redo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.deletedActionClass) {
            try {
                IFileState[] state = this.javaClassFile.getHistory(progressMonitor);
                if (state != null && state.length > 0) {
                    this.javaClassFile.create(state[0].getContents(), false, progressMonitor);
                }
                Debug.noop();
            }
            catch (CoreException e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        if (this.facesChangeCommand != null && this.facesChangeCommand.canUndo()) {
            this.facesChangeCommand.undo();
        }
        if (this.deletedActionMethod) {
            IJavaProject jp = JavaCore.create((IProject)FacesProvider.getProjectForElement((CommonElement)this.getNode()));
            try {
                IResource res;
                String clazz = this.beanHandle.getLinkText();
                IType t = jp.findType(clazz);
                IMethod method = t.getMethod(this.actionHandle.getActionName(), new String[0]);
                if (!method.exists() && (res = t.getUnderlyingResource()) instanceof IFile) {
                    IFile pageCodeFile = (IFile)res;
                    FacesUtils.addActionToManagedBean(pageCodeFile, this.actionHandle.getActionName(), FacesCommandHelper.actionMethodContents);
                }
            }
            catch (JavaModelException e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        if (this.deleteFacesActionFromViewsCommand != null) {
            this.deleteFacesActionFromViewsCommand.undo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    private CompositeCommand getDeleteFromViewsCommand() {
        CompositeCommand compositeCmd = new CompositeCommand(null);
        EList compartments = this.getNode().getCompartments();
        for (Compartment compartment : compartments) {
            if (!compartment.getType().equals("com.ibm.etools.model2.diagram.web.LinksCompartment") || compartment.getItems().size() <= 0) continue;
            for (NodeItem item : compartment.getItems()) {
                DeleteNavigationCaseResourceCommand cmd = new DeleteNavigationCaseResourceCommand(item, this.resourcesToDelete);
                compositeCmd.compose((IUndoableOperation)cmd);
            }
        }
        return compositeCmd;
    }

    public ResourceTree getDeletionTree() {
        IFile javaClass;
        ResourceTree tree = new ResourceTree();
        FacesAction actionMappingHandle = (FacesAction)this.getNode().getAdapter(FacesAction.class);
        if (actionMappingHandle != null && (javaClass = this.getJavaClassFile(actionMappingHandle)) != null && javaClass.exists()) {
            IJavaElement element = JavaCore.create((IFile)javaClass);
            String javaClassName = element.getElementName();
            String text = NLS.bind((String)ResourceHandler.RemoveActionClassX, (Object)javaClassName);
            ILink bean = actionMappingHandle.managedbean;
            if (bean != null) {
                IJavaProject jp = JavaCore.create((IProject)FacesProvider.getProjectForElement((CommonElement)this.getNode()));
                try {
                    if (this.shouldDeleteManagedBean()) {
                        ResourceDescriptor desc = new ResourceDescriptor((Object)bean);
                        IFile file = (IFile)bean.getContainer().getResource();
                        desc.setDisplayText(NLS.bind((String)ResourceHandler.RemoveFacesActionXinX, (Object)actionMappingHandle.getBeanName(), (Object)file.getProjectRelativePath().makeAbsolute().toString()));
                        tree.addChild(desc);
                        ResourceDescriptor desc2 = new ResourceDescriptor((Object)javaClass);
                        desc2.setDisplayText(text);
                        tree.addChild(desc2);
                    } else {
                        String clazz = AbstractWebProvider.trimQuotes((String)bean.getLinkText());
                        IType t = jp.findType(clazz);
                        IMethod method = t.getMethod(actionMappingHandle.getActionName(), new String[0]);
                        if (method.exists()) {
                            text = NLS.bind((String)ResourceHandler.RemoveMethodXFromClassY, (Object)method.getElementName(), (Object)javaClassName);
                        }
                        ResourceDescriptor desc2 = new ResourceDescriptor((Object)method);
                        desc2.setDisplayText(text);
                        tree.addChild(desc2);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                return tree;
            }
        }
        return null;
    }

    private IFile getJavaClassFile(FacesAction actionHandle) {
        ILink beanHandle;
        if (actionHandle != null && (beanHandle = actionHandle.managedbean) != null) {
            ILink javaTarget = FacesLinkUtil.getJavaTarget((ILink)beanHandle);
            if (javaTarget != null) {
                LinkNode container = javaTarget.getContainer();
                if (container != null) {
                    return (IFile)container.getResource();
                }
            } else {
                String className = beanHandle.getLinkText();
                IJavaProject javaProject = JavaCore.create((IProject)actionHandle.managedbean.getContainer().getResource().getProject());
                if (javaProject != null) {
                    IType targetClassType = null;
                    try {
                        targetClassType = javaProject.findType(className);
                    }
                    catch (JavaModelException javaModelException) {}
                    if (targetClassType != null) {
                        return (IFile)targetClassType.getResource();
                    }
                }
            }
        }
        return null;
    }

    private ManagedBeanType getManageBean(EList<ManagedBeanType> beans, String name) {
        if (beans != null) {
            for (Object o : beans) {
                ManagedBeanType b = (ManagedBeanType)o;
                String thisBeanName = b.getManagedBeanName().getTextContent();
                if (thisBeanName == null || !thisBeanName.equals(name)) continue;
                return b;
            }
        }
        return null;
    }

    private MNode getNode() {
        return this.node;
    }

    private boolean shouldDeleteManagedBean() {
        IJavaElement element;
        IFile javaClass;
        boolean allMethodsSelected = true;
        FacesAction actionMappingHandle = (FacesAction)this.getNode().getAdapter(FacesAction.class);
        if (actionMappingHandle != null && (javaClass = this.getJavaClassFile(actionMappingHandle)) != null && javaClass.exists() && (element = JavaCore.create((IFile)javaClass)) instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)element;
            IType type = cu.findPrimaryType();
            try {
                IMethod[] iMethodArray = type.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod meth = iMethodArray[n2];
                    if (!meth.isConstructor() && !this.selectedMethods.containsKey(meth.getElementName())) {
                        allMethodsSelected = false;
                        break;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return allMethodsSelected;
    }
}

