/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.internal;

import com.ibm.etools.model2.base.util.WizardUtils;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.javamodel.commands.CreateMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.DeleteMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.JavaCommand;
import com.ibm.etools.webtools.javamodel.tasks.ExecuteSingleJavaCommandTask;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class FacesUtils {
    public static boolean methodExists(IProject project, String actionMethod, IFile javaFile) {
        IType type;
        IJavaElement jE = JavaCore.create((IFile)javaFile);
        return jE instanceof ICompilationUnit && (type = ((ICompilationUnit)jE).findPrimaryType()) != null && FacesUtils.getActionMethod(type, actionMethod) != null;
    }

    public static boolean addActionToManagedBean(IFile pageCodeFile, String actionMethod, String contents) {
        IPath javaPath = pageCodeFile.getProjectRelativePath().makeAbsolute();
        IProject project = pageCodeFile.getProject();
        JavaModel model = JavaModelManager.getInstance().getModel("codebehind", project, javaPath);
        try {
            if (model != null) {
                CreateMethodCommand cmd = new CreateMethodCommand();
                cmd.setForce(false);
                cmd.setIdentifier(actionMethod);
                cmd.setReturnType("String");
                cmd.setModifier("public");
                cmd.setContents(contents);
                ExecuteSingleJavaCommandTask task = new ExecuteSingleJavaCommandTask((JavaCommand)cmd);
                model.runBlockingJavaTask((AbstractJavaModelTask)task, null, null);
                model.saveNow(null);
                return true;
            }
        }
        finally {
            if (model != null) {
                model.release();
            }
        }
        return false;
    }

    public static boolean renameManagedBeanAction(IProject project, String className, String oldActionName, String newActionName, IProgressMonitor monitor) {
        IType t;
        IJavaProject jp = JavaCore.create((IProject)project);
        try {
            t = jp.findType(className);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        if (t == null) {
            return false;
        }
        IMethod m = FacesUtils.getActionMethod(t, oldActionName);
        if (m != null) {
            try {
                m.rename(newActionName, true, monitor);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return true;
    }

    public static String getActionMethodContents(IProject project, String className, String actionName, IProgressMonitor monitor) {
        IType t;
        IJavaProject jp = JavaCore.create((IProject)project);
        try {
            t = jp.findType(className);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (t == null) {
            return null;
        }
        IMethod m = FacesUtils.getActionMethod(t, actionName);
        if (m != null) {
            try {
                return m.getSource();
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    public static void removeManagedBeanAction(IFile pageCodeFile, String actionMethod) {
        IPath javaPath = pageCodeFile.getProjectRelativePath().makeAbsolute();
        IProject project = pageCodeFile.getProject();
        JavaModel model = JavaModelManager.getInstance().getModel("codebehind", project, javaPath);
        try {
            if (model != null) {
                DeleteMethodCommand cmd = new DeleteMethodCommand();
                cmd.setIdentifier(actionMethod);
                cmd.setModifier("public");
                ExecuteSingleJavaCommandTask task = new ExecuteSingleJavaCommandTask((JavaCommand)cmd);
                model.runBlockingJavaTask((AbstractJavaModelTask)task, null, null);
                model.saveNow(null);
            }
        }
        finally {
            if (model != null) {
                model.release();
            }
        }
    }

    public static IType getType(IProject project, String className) {
        IJavaProject jp = JavaCore.create((IProject)project);
        try {
            return jp.findType(className);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IMethod getActionMethod(IProject project, String className, String methodName) {
        IType t = FacesUtils.getType(project, className);
        return FacesUtils.getActionMethod(t, methodName);
    }

    public static IMethod getActionMethod(IType t, String methodName) {
        IMethod[] ma;
        assert (t != null);
        assert (methodName != null && methodName.length() > 0);
        try {
            ma = t.getMethods();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (ma == null) {
            return null;
        }
        if (ma.length == 0) {
            return null;
        }
        int i = 0;
        while (i < ma.length) {
            block11: {
                String[] pta;
                String mn;
                IMethod m = ma[i];
                if (m != null && (mn = m.getElementName()) != null && mn.length() != 0 && mn.equals(methodName) && ((pta = m.getParameterTypes()) == null || pta.length == 0)) {
                    String rt = null;
                    try {
                        rt = m.getReturnType();
                    }
                    catch (JavaModelException javaModelException) {
                        break block11;
                    }
                    if (!WizardUtils.isEmpty((String)rt) && rt.equals("QString;")) {
                        return m;
                    }
                }
            }
            ++i;
        }
        return null;
    }
}

