/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.ui.internal.providers.config;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.IConfiguratorProvider;
import com.ibm.etools.diagram.ui.internal.adapters.OpenAdapter;
import com.ibm.etools.diagram.ui.internal.adapters.ResourceSelectionDialogAdapter;
import com.ibm.etools.jsf.support.dialogs.SelectFacesActionDialog;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.model2.diagram.faces.ui.internal.FacesUIPlugin;
import com.ibm.etools.model2.diagram.faces.ui.internal.nls.ResourceHandler;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.faces.FacesAction;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import com.ibm.etools.references.web.faces.FacesNavigation;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.statushandlers.StatusManager;

public class FacesUIConfiguratorProvider
extends FacesProvider
implements IConfiguratorProvider {
    private void addAdapters(CommonElement element) {
        if (FacesProvider.isFacesActionNode((TypedElement)element)) {
            element.addAdapter((Object)new FacesActionOpenAdapter((MNode)element), OpenAdapter.class);
            element.addAdapter((Object)new FacesActionSelectionDialogAdapter(element), ResourceSelectionDialogAdapter.class);
        } else if (FacesProvider.isActionInvocationItem((TypedElement)element) || FacesProvider.isFacesRequestLinkItem((TypedElement)element)) {
            element.addAdapter((Object)new FacesItemOpenAdapter((Item)element), OpenAdapter.class);
            element.addAdapter((Object)new FacesActionSelectionDialogAdapter(element), ResourceSelectionDialogAdapter.class);
        } else if (FacesProvider.isPageCodeOutcomeItem((TypedElement)element)) {
            element.addAdapter((Object)new FacesConfigOpenAdpater((Item)element), OpenAdapter.class);
        } else if (FacesProvider.isFacesActionFromViewItem((TypedElement)element)) {
            element.addAdapter((Object)new FacesConfigOpenAdpater((Item)element), OpenAdapter.class);
        } else if (FacesProvider.isActionOutcomeItem((TypedElement)element)) {
            element.addAdapter((Object)new FacesConfigOpenAdpater((Item)element), OpenAdapter.class);
        }
    }

    public void configureNew(CommonElement element) {
        this.addAdapters(element);
    }

    public void configureLoad(CommonElement element) {
        this.addAdapters(element);
    }

    public void configureExisting(CommonElement element, Object existing, Map options) {
        this.addAdapters(element);
    }

    private static class FacesActionOpenAdapter
    extends OpenAdapter {
        private final MNode node;

        public FacesActionOpenAdapter(MNode node) {
            this.node = node;
        }

        public IFile getFileToOpen() {
            FacesAction action = (FacesAction)this.node.getAdapter(FacesAction.class);
            if (action != null) {
                return (IFile)action.managedbean.getContainer().getResource();
            }
            return null;
        }

        public ISelection getSelectionToReveal() {
            return null;
        }

        public void openEditor() throws PartInitException {
            block5: {
                FacesAction action = (FacesAction)this.node.getAdapter(FacesAction.class);
                if (action != null) {
                    ILink javaMethod = action.javaMethod;
                    IResource resource = javaMethod.getContainer().getResource();
                    ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
                    try {
                        IMethod method = cu.getTypes()[0].getMethod(javaMethod.getName(), new String[0]);
                        if (method != null) {
                            IEditorPart part = JavaUI.openInEditor((IJavaElement)method);
                            JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)method);
                            break block5;
                        }
                        JavaUI.openInEditor((IJavaElement)cu);
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                } else {
                    super.openEditor();
                }
            }
        }
    }

    private static class FacesActionSelectionDialogAdapter
    extends ResourceSelectionDialogAdapter {
        private final CommonElement node;

        public FacesActionSelectionDialogAdapter(CommonElement node) {
            this.node = node;
        }

        public SelectionDialog getDialog(Shell shell, Map params) {
            if (this.node.isRealized()) {
                return null;
            }
            MNode mnode = null;
            if (this.node instanceof NodeItem) {
                mnode = ((NodeItem)this.node).getNode();
            } else if (this.node instanceof MNode) {
                mnode = (MNode)this.node;
            }
            if (mnode != null) {
                SelectFacesActionDialog dialog;
                IProject project;
                ILink managedBeanLink = null;
                FacesAction action = (FacesAction)mnode.getAdapter(FacesAction.class);
                if (action == null) {
                    IFile jspFile = WebProvider.getFileForNode((MNode)mnode);
                    if (jspFile != null) {
                        String beanName = CodeBehindUtil.getManagedBeanName((IFile)jspFile);
                        managedBeanLink = FacesLinkUtil.getManagedBeanLink((String)beanName, (IProject)jspFile.getProject());
                    }
                } else {
                    managedBeanLink = action.managedbean;
                }
                if (managedBeanLink != null) {
                    project = managedBeanLink.getContainer().getResource().getProject();
                    dialog = new SelectFacesActionDialog(shell, project, managedBeanLink);
                    return dialog;
                }
                project = WebProvider.getProjectForElement((CommonElement)this.node);
                dialog = new SelectFacesActionDialog(shell, project, null);
                return dialog;
            }
            return null;
        }

        public String getStringForResult(Object value) {
            if (value instanceof FacesAction) {
                String name = String.valueOf(((FacesAction)value).managedbean.getName()) + "." + ((FacesAction)value).javaMethod.getName();
                return name;
            }
            return super.getStringForResult(value);
        }
    }

    private class FacesConfigOpenAdpater
    extends OpenAdapter {
        private final Item item;

        public FacesConfigOpenAdpater(Item item) {
            this.item = item;
        }

        public IFile getFileToOpen() {
            FacesNavigation facesActionHandle = (FacesNavigation)this.item.getAdapter(FacesNavigation.class);
            if (facesActionHandle != null) {
                return facesActionHandle.getFacesConfigFile();
            }
            ILink navHandle = (ILink)this.item.getAdapter(ILink.class);
            if (navHandle != null) {
                return (IFile)navHandle.getContainer().getResource();
            }
            return null;
        }
    }

    public class FacesItemOpenAdapter
    extends OpenAdapter {
        private final Item node;
        private String managedBeanClass;
        private String methodName;

        public FacesItemOpenAdapter(Item node) {
            this.node = node;
        }

        public IFile getFileToOpen() {
            return null;
        }

        public void openEditor() throws PartInitException {
            FacesAction action;
            this.methodName = null;
            this.managedBeanClass = null;
            ILink cmdLink = (ILink)this.node.getAdapter(ILink.class);
            IProject project = null;
            if (cmdLink != null && (action = FacesLinkUtil.getFacesActionTarget((ILink)cmdLink)) != null) {
                this.managedBeanClass = AbstractWebProvider.trimQuotes((String)action.managedbean.getLinkText());
                if (action.javaMethod != null) {
                    this.methodName = action.getActionName();
                }
                project = action.managedbean.getContainer().getResource().getProject();
            }
            if (this.methodName == null || this.managedBeanClass == null) {
                Status s = new Status(4, FacesUIPlugin.getDefault().getBundle().getSymbolicName(), 4, ResourceHandler.CouldNotLocatetheJavaClassForThisFacesAction, null);
                StatusManager.getManager().handle((IStatus)s, 4);
                return;
            }
            ICompilationUnit javaClass = Model2Util.getJavaElementFromClassName(project, (String)this.managedBeanClass);
            if (javaClass == null) {
                return;
            }
            try {
                IMethod method = javaClass.getTypes()[0].getMethod(this.methodName, new String[0]);
                if (method == null) {
                    JavaUI.openInEditor((IJavaElement)javaClass);
                } else {
                    IEditorPart part = JavaUI.openInEditor((IJavaElement)method);
                    JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)method);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }
}

