/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.faces.ui.internal.properties.sections;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigSchemeUtil;
import com.ibm.etools.model2.diagram.faces.internal.providers.FacesProvider;
import com.ibm.etools.model2.diagram.faces.ui.internal.nls.ResourceHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractNotationPropertiesSection;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;

public class FacesDiagramLevelSection
extends AbstractNotationPropertiesSection {
    private Text combo;
    private Label folderLabel;
    private Composite expandableClientArea;
    private Hyperlink link;

    protected void initializeControls(Composite parent) {
        Composite sectionComposite = this.getWidgetFactory().createComposite(parent, 0);
        sectionComposite.setLayout((Layout)new GridLayout());
        ExpandableComposite web = this.getWidgetFactory().createExpandableComposite(sectionComposite, 64);
        web.setLayout((Layout)new GridLayout());
        web.setLayoutData((Object)new GridData(1, 1, false, false));
        web.setText(ResourceHandler.Faces);
        this.expandableClientArea = this.getWidgetFactory().createComposite((Composite)web, 0);
        this.expandableClientArea.setLayout((Layout)new GridLayout(2, false));
        this.expandableClientArea.setLayoutData((Object)new GridData(1, 1, false, false));
        web.setClient((Control)this.expandableClientArea);
        this.getWidgetFactory().createLabel(this.expandableClientArea, ResourceHandler.FacesConfigFile_colon);
        this.link = this.getWidgetFactory().createHyperlink(this.expandableClientArea, "", 0);
        this.link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IFile facesconfig = FacesDiagramLevelSection.this.getFacesConfig();
                try {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)facesconfig);
                }
                catch (PartInitException e1) {
                    StatusManager.getManager().handle(e1.getStatus(), 3);
                }
            }
        });
    }

    public static String convertFoldersToDisplayString(String module) {
        if ("".equals(module)) {
            return ResourceHandler.DefaultFacesFolder;
        }
        return module;
    }

    public IFile getDiagramFile() {
        if (this.getPart() == null) {
            return null;
        }
        View diagramView = (View)this.getPart().getAdapter(View.class);
        if (diagramView != null) {
            return WorkspaceSynchronizer.getFile((Resource)diagramView.eResource());
        }
        return null;
    }

    protected EObject getSemanticObject() {
        IGraphicalEditPart part = this.getSingleInput();
        if (part == null) {
            return null;
        }
        EObject o = part.resolveSemanticElement();
        if (o == null) {
            return null;
        }
        return o;
    }

    protected IFile getFacesConfig() {
        IResource folder = FacesProvider.getDefaultFacesFolder((CommonElement)((CommonElement)this.getSemanticObject()));
        MDiagram d = (MDiagram)this.getSemanticObject();
        if (d != null && folder != null) {
            FacesConfigArtifactEdit edit = null;
            try {
                edit = FacesConfigSchemeUtil.getFacesConfigArtifactEditManagedBeanForRead((IResource)folder);
                IFile iFile = edit.getFile();
                return iFile;
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        return null;
    }

    public void refresh() {
        super.refresh();
        IFile file = this.getDiagramFile();
        if (file != null) {
            IResource facesFolder = FacesProvider.getDefaultFacesFolder((CommonElement)((CommonElement)this.getSemanticObject()));
            IFile facesConfig = this.getFacesConfig();
            if (facesConfig != null) {
                String facesPath = facesConfig.getProjectRelativePath().makeAbsolute().toString();
                if (facesPath == null) {
                    facesPath = "";
                }
                this.link.setText(facesPath);
            }
            if (facesFolder instanceof IProject) {
                if (this.folderLabel != null) {
                    this.folderLabel.dispose();
                }
                if (this.combo != null) {
                    this.combo.dispose();
                }
            } else {
                this.folderLabel = this.getWidgetFactory().createLabel(this.expandableClientArea, ResourceHandler.DefaultFacesFolder_colon);
                this.combo = this.getWidgetFactory().createText(this.expandableClientArea, "", 0x800000);
                this.combo.setText(facesFolder.getProjectRelativePath().toString());
            }
        }
    }
}

