/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.util;

import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.util.HTMLTaglibDirectiveUtil;
import com.ibm.etools.webedit.util.ITaglibDirective;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

public final class TaglibUtil {
    private TaglibUtil() {
    }

    public static ITaglibDirective getTaglibDirective(HTMLEditDomain editDomain, String uri) {
        IDOMModel model;
        IFile file = TaglibUtil.getFile(editDomain);
        if (file != null && (model = TaglibUtil.getModel(editDomain)) != null) {
            return TaglibUtil.getTaglibDirective(file, model, uri);
        }
        return null;
    }

    public static ITaglibDirective getTaglibDirective(IFile file, IDOMModel model, String uri) {
        String basePath = file.getFullPath().toString();
        Object[] directives = HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model);
        int d = 0;
        while (d < directives.length) {
            ITaglibDirective directive = (ITaglibDirective)directives[d];
            ITaglibRecord record = TaglibIndex.resolve((String)basePath, (String)directive.getURI(), (boolean)false);
            if (record != null && TaglibUtil.isMatch(uri, record)) {
                return directive;
            }
            ++d;
        }
        return null;
    }

    public static String getUniquePrefix(HTMLEditDomain editDomain, String prefix) {
        IDOMModel model = TaglibUtil.getModel(editDomain);
        if (model != null) {
            return TaglibUtil.getUniquePrefix(model, prefix);
        }
        return prefix;
    }

    public static String getUniquePrefix(IDOMModel model, String prefix) {
        Object[] directives = HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model);
        if (!TaglibUtil.prefixPresent(prefix, directives)) {
            return prefix;
        }
        int n = 0;
        String candidate;
        while (TaglibUtil.prefixPresent(candidate = String.valueOf(prefix) + n, directives)) {
            ++n;
        }
        return candidate;
    }

    public static Element getJSPRootElement(IDOMModel model) {
        Element element;
        if (model != null && (element = model.getDocument().getDocumentElement()) != null && element.getNodeName().equals("jsp:root")) {
            return element;
        }
        return null;
    }

    public static boolean isXMLSyntax(IDOMModel model) {
        Element root;
        return model != null && (root = TaglibUtil.getJSPRootElement(model)) != null;
    }

    public static IFile getFile(HTMLEditDomain editDomain) {
        IPath path = editDomain.getActiveSubModelContext().getFileBase().makeRelative();
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(path);
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    private static boolean isMatch(String uri, ITaglibRecord record) {
        String recordURI = TaglibUtil.getURI(record);
        return uri.equals(recordURI);
    }

    private static String getURI(ITaglibRecord record) {
        switch (record.getRecordType()) {
            case 1: {
                return ((ITLDRecord)record).getURI();
            }
            case 4: {
                return ((IURLRecord)record).getURI();
            }
        }
        return null;
    }

    private static IDOMDocument getDocument(HTMLEditDomain editDomain) {
        if (editDomain != null) {
            return editDomain.getActiveModel().getDocument();
        }
        return null;
    }

    private static IDOMModel getModel(HTMLEditDomain editDomain) {
        IDOMDocument document = TaglibUtil.getDocument(editDomain);
        if (document != null) {
            return document.getModel();
        }
        return null;
    }

    private static boolean prefixPresent(String prefix, Object[] directives) {
        int d = 0;
        while (d < directives.length) {
            ITaglibDirective directive = (ITaglibDirective)directives[d];
            if (prefix.equals(directive.getPrefix())) {
                return true;
            }
            ++d;
        }
        return false;
    }
}

