/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaResourceFinder {
    private IPackageFragmentRoot javaRoot;
    private IPath filePath;
    private IResource javaResource;
    private IJavaProject javaProject;
    private IProject workbenchProject;

    public JavaResourceFinder() {
    }

    public JavaResourceFinder(IPath filePath) {
        this.setFilePath(filePath);
    }

    public JavaResourceFinder(IJavaProject ijp) {
        assert (ijp != null);
        this.setJavaProject(ijp);
        this.setFilePath(ijp.getPath());
    }

    private IPath getFilePath() {
        return this.filePath;
    }

    public IFile getIFileResource(String packageClass) {
        IType type;
        block3: {
            try {
                type = this.getITypeResource(packageClass);
                if (type != null) break block3;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return (IFile)type.getUnderlyingResource();
    }

    public IType getITypeResource(String packageClass) {
        try {
            return this.getJavaProject().findType(packageClass);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IJavaProject getJavaProject() {
        if (this.javaProject == null) {
            this.setJavaProject(JavaCore.create((IProject)this.getWorkbenchProject()));
        }
        return this.javaProject;
    }

    private IResource getJavaResource() {
        if (this.javaResource == null) {
            this.setJavaResource((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(this.getFilePath()).getParent());
        }
        return this.javaResource;
    }

    public IPackageFragmentRoot getJavaRoot() {
        if (this.javaRoot == null) {
            this.setJavaRoot(this.getJavaProject().getPackageFragmentRoot(this.getJavaResource()));
        }
        return this.javaRoot;
    }

    public IProject getWorkbenchProject() {
        if (this.workbenchProject == null) {
            this.setWorkbenchProject(this.getJavaResource().getProject());
        }
        return this.workbenchProject;
    }

    private void setFilePath(IPath filePath) {
        this.filePath = filePath;
    }

    private void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    private void setJavaResource(IResource javaResource) {
        this.javaResource = javaResource;
    }

    private void setJavaRoot(IPackageFragmentRoot javaRoot) {
        this.javaRoot = javaRoot;
    }

    private void setWorkbenchProject(IProject workbenchProject) {
        this.workbenchProject = workbenchProject;
    }
}

