/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.util;

import com.ibm.etools.model2.base.Model2BasePlugin;
import com.ibm.etools.model2.base.nls.ResourceHandler;
import com.ibm.etools.model2.base.util.JavaResourceFinder;
import com.ibm.etools.model2.base.util.Model2ProjectPropertyUtils;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class CommonDialogManager {
    public static final String ERROR = ResourceHandler.Dialog_error;
    public static final String INFORMATION = ResourceHandler.Dialog_information;

    public static void openErrorDialog(String message) {
        CommonDialogManager.openErrorDialog(ERROR, message);
    }

    public static void openErrorDialog(String title, String message) {
        MessageDialog.openError((Shell)CommonDialogManager.getShell(), (String)title, (String)message);
    }

    public static void openInfoDialog(String message) {
        CommonDialogManager.openInfoDialog(INFORMATION, message);
    }

    public static void openInfoDialog(String title, String message) {
        MessageDialog.openInformation((Shell)CommonDialogManager.getShell(), (String)title, (String)message);
    }

    public static boolean openYesNoDialog(String title, String message) {
        MessageDialog dialog = new MessageDialog(CommonDialogManager.getShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        return dialog.open() == 0;
    }

    public static boolean openWizard(IWizard wizard) {
        WizardDialog dialog = new WizardDialog(CommonDialogManager.getShell(), wizard);
        dialog.create();
        return dialog.open() == 0;
    }

    public static boolean openJavaEditor(String className, JavaResourceFinder finder) {
        IType type = CommonDialogManager.getType(className, finder);
        return type != null ? CommonDialogManager.openJavaEditor(type) : false;
    }

    public static boolean openJavaEditor(IType type) {
        try {
            return JavaUI.openInEditor((IJavaElement)type) != null;
        }
        catch (Exception exception) {
            Model2BasePlugin.getLogger().log(exception);
            return false;
        }
    }

    public static IType getType(String className, JavaResourceFinder finder) {
        if (className != null && className.length() > 0 && finder != null) {
            return finder.getITypeResource(className);
        }
        return null;
    }

    public static String openJavaWizard(String className, JavaResourceFinder finder, String superClass, List superInterfaces) {
        int i;
        IPackageFragment packageFragment = null;
        if (className != null && (i = className.lastIndexOf(46)) != -1) {
            packageFragment = finder.getJavaRoot().getPackageFragment(className.substring(0, i));
            className = className.substring(i + 1);
        }
        if (packageFragment == null) {
            String defaultRoot = Model2ProjectPropertyUtils.getPackagePrefix(finder.getWorkbenchProject());
            packageFragment = finder.getJavaRoot().getPackageFragment(defaultRoot);
        }
        NewClassWizardPage page = new NewClassWizardPage();
        page.init((IStructuredSelection)new StructuredSelection((Object)finder.getJavaProject()));
        if (packageFragment != null) {
            page.setPackageFragment(packageFragment, true);
        }
        if (className != null) {
            page.setTypeName(className, true);
        }
        if (superClass != null) {
            page.setSuperClass(superClass, true);
        }
        if (superInterfaces != null) {
            page.setSuperInterfaces(superInterfaces, true);
        }
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        action.setConfiguredWizardPage(page);
        action.setShell(CommonDialogManager.getShell());
        action.run();
        IJavaElement element = action.getCreatedElement();
        if (element != null && element.getElementType() == 7) {
            return ((IType)element).getFullyQualifiedName();
        }
        return null;
    }

    public static String openEditorOrWizard(String className, JavaResourceFinder finder, String superClass, List superInterfaces) {
        IType type = CommonDialogManager.getType(className, finder);
        if (type != null) {
            CommonDialogManager.openJavaEditor(type);
            return null;
        }
        return CommonDialogManager.openJavaWizard(className, finder, superClass, superInterfaces);
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getShell() {
        Shell shell;
        Display display = CommonDialogManager.getDisplay();
        if (display != null && (shell = display.getActiveShell()) != null) {
            return shell;
        }
        return CommonDialogManager.getActiveWorkbenchShell();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            return workbenchWindow.getShell();
        }
        return null;
    }

    public static String openClassBrowser(IVirtualComponent component, String typeName) {
        IType type = CommonDialogManager.openClassBrowser2(component, typeName);
        return type == null ? null : type.getFullyQualifiedName();
    }

    public static IType openClassBrowser2(IVirtualComponent component, String typeName) {
        IJavaSearchScope searchScope;
        block7: {
            IType type;
            IJavaProject javaProject;
            block6: {
                javaProject = JavaCore.create((IProject)component.getProject());
                try {
                    type = javaProject.findType(typeName);
                    if (type != null) break block6;
                    return null;
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            searchScope = null;
            if (type.isClass()) {
                searchScope = !"java.lang.Object".equals(type.getFullyQualifiedName()) ? SearchEngine.createHierarchyScope((IType)type) : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject}, (boolean)true);
                break block7;
            }
            if (type.isInterface()) {
                searchScope = SearchEngine.createHierarchyScope((IType)type);
                break block7;
            }
            return null;
        }
        IType selectedType = CommonDialogManager.getSelectedType(searchScope, (IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        return selectedType;
    }

    private static IType getSelectedType(IJavaSearchScope scope, IRunnableContext context) {
        try {
            SelectionDialog typeDialog = JavaUI.createTypeDialog((Shell)CommonDialogManager.getActiveWorkbenchShell(), (IRunnableContext)context, (IJavaSearchScope)scope, (int)512, (boolean)false, (String)"", null);
            typeDialog.setTitle(ResourceHandler.Dialog_select_class_title);
            typeDialog.setMessage(ResourceHandler.Dialog_select_class_message);
            if (typeDialog.open() == 0) {
                return (IType)typeDialog.getResult()[0];
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }
}

