/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.util;

import com.ibm.etools.model2.base.nls.ResourceHandler;
import com.ibm.etools.model2.base.util.WizardUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.JavaConventions;

public abstract class Accessor
implements Comparable {
    public static final String NO_NAME = ResourceHandler.wizards_common_NoName_token;
    public static final String NO_TYPE = ResourceHandler.wizards_common_NoType_token;
    protected static Map TYPE_MAP = null;
    protected String name;
    protected String type;

    static {
        TYPE_MAP = Accessor.initMap(new HashMap());
    }

    protected static Map initMap(Map m) {
        return m;
    }

    public Accessor() {
        this(NO_NAME, NO_TYPE);
    }

    public Accessor(String name) {
        this(name, NO_TYPE);
    }

    protected Accessor(String n, String t) {
        boolean isIndexed = false;
        if (WizardUtils.isEmpty(n)) {
            this.name = NO_NAME;
        } else {
            assert (n.lastIndexOf(46) == -1);
            int i = n.lastIndexOf(91);
            if (i == -1) {
                this.name = n;
            } else {
                isIndexed = true;
                this.name = n.substring(0, i);
                assert (this.name.lastIndexOf(91) == -1);
            }
        }
        this.type = Accessor.mapType(t, isIndexed);
    }

    protected static String mapType(String type, boolean wasIndexed) {
        String mapped;
        if (WizardUtils.isEmpty(type)) {
            return NO_TYPE;
        }
        if (TYPE_MAP == null) {
            TYPE_MAP = Accessor.initMap(new HashMap());
        }
        if (WizardUtils.isEmpty(mapped = (String)TYPE_MAP.get(type))) {
            if (wasIndexed) {
                return new StringBuffer(type).append("[]").toString();
            }
            return type;
        }
        if (wasIndexed) {
            return new StringBuffer(mapped).append("[]").toString();
        }
        return mapped;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static boolean isValidName(String name) {
        return JavaConventions.validateIdentifier((String)name).isOK();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static boolean isValidType(String type) {
        return JavaConventions.validateJavaTypeName((String)type).isOK();
    }

    public static boolean areValidParams(String name, String type) {
        return Accessor.isValidName(name) && Accessor.isValidType(type);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.name + ", " + this.type + ")";
    }

    public boolean equals(Object object) {
        if (object instanceof Accessor) {
            Accessor accessor = (Accessor)object;
            return accessor.getName().equals(this.name) && accessor.getType().equals(this.type);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() + this.name.hashCode();
    }

    public int compareTo(Object object) {
        Accessor accessor = (Accessor)object;
        int result = this.name.compareTo(accessor.getName());
        if (result == 0) {
            result = this.type.compareTo(accessor.getType());
        }
        return result;
    }
}

