/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.facet;

import com.ibm.etools.model2.base.facet.FacetWeights;
import com.ibm.etools.model2.base.facet.IFacetWeighted;
import com.ibm.etools.model2.base.facet.ProjectFacetUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class FacetWeightedUtil {
    public static final int NO_WEIGHT = -1;
    public static final int MIN_WEIGHT = 0;
    public static final int MAX_WEIGHT = 100;
    public static final int DEFAULT_WEIGHT = 0;
    public static final String FacetElementId = "facet";
    public static final String FacetIdAttribute = "facetId";
    public static final String WeightAttribute = "weight";

    public static void readFacetWeights(IFacetWeighted weighted, IConfigurationElement element) {
        FacetWeights weights = weighted.getFacetWeights();
        IConfigurationElement[] facetElements = element.getChildren(FacetElementId);
        int i = 0;
        while (i < facetElements.length) {
            IConfigurationElement facetElement = facetElements[i];
            String facetId = facetElement.getAttribute(FacetIdAttribute);
            if (facetId != null) {
                int weight = 0;
                String weightString = facetElement.getAttribute(WeightAttribute);
                if (weightString != null) {
                    try {
                        weight = Integer.parseInt(weightString);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    weight = Math.min(Math.max(weight, 0), 100);
                }
                weights.put(facetId, weight);
            }
            ++i;
        }
    }

    public static FacetWeights readFacetWeights(IConfigurationElement element) {
        FacetWeights weights = new FacetWeights();
        IConfigurationElement[] facetElements = element.getChildren(FacetElementId);
        int i = 0;
        while (i < facetElements.length) {
            IConfigurationElement facetElement = facetElements[i];
            String facetId = facetElement.getAttribute(FacetIdAttribute);
            if (facetId != null) {
                int weight = 0;
                String weightString = facetElement.getAttribute(WeightAttribute);
                if (weightString != null) {
                    try {
                        weight = Integer.parseInt(weightString);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    weight = Math.min(Math.max(weight, 0), 100);
                }
                weights.put(facetId, weight);
            }
            ++i;
        }
        return weights;
    }

    public static IFacetWeighted getHeaviest(Collection weighteds, IProject project) {
        IFacetWeighted heaviest = null;
        int heaviestWeight = -1;
        for (IFacetWeighted weighted : weighteds) {
            int weight = FacetWeightedUtil.getWeight(weighted, project);
            if (weight > heaviestWeight) {
                heaviestWeight = weight;
                heaviest = weighted;
            }
            if (heaviestWeight != -1 || weight != -1) continue;
            heaviest = weighted;
        }
        return heaviest;
    }

    public static boolean hasWeight(IFacetWeighted weighted, IProject project) {
        FacetWeights weights = weighted.getFacetWeights();
        Iterator iterator = FacetWeightedUtil.getFacetIdIterator(project);
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            if (!weights.containsFacet(id)) continue;
            return true;
        }
        return false;
    }

    private static int getWeight(IFacetWeighted weighted, IProject project) {
        int maxWeight = -1;
        FacetWeights weights = weighted.getFacetWeights();
        Iterator iterator = FacetWeightedUtil.getFacetIdIterator(project);
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            int weight = weights.get(id);
            if (weight <= maxWeight) continue;
            maxWeight = weight;
        }
        return maxWeight;
    }

    static final Iterator getFacetIdIterator(IProject project) {
        return new FacetIdIterator(FacetWeightedUtil.getFacetVersions(project));
    }

    static Set getFacetVersions(IProject project) {
        if (project != null) {
            return ProjectFacetUtil.getInstalledFacetVersionsAliased(project);
        }
        return Collections.EMPTY_SET;
    }

    static final class FacetIdIterator
    implements Iterator {
        private final Iterator facetVersionsIterator;

        public FacetIdIterator(Set facetVersions) {
            this.facetVersionsIterator = facetVersions.iterator();
        }

        public Object next() {
            if (this.facetVersionsIterator.hasNext()) {
                return ((IProjectFacetVersion)this.facetVersionsIterator.next()).getProjectFacet().getId();
            }
            return null;
        }

        @Override
        public void remove() {
            this.facetVersionsIterator.remove();
        }

        @Override
        public boolean hasNext() {
            return this.facetVersionsIterator.hasNext();
        }
    }
}

