/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.facet;

import com.ibm.etools.model2.base.Model2BasePlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class FacetAliasesRegistry {
    private static FacetAliasesRegistry INSTANCE;
    private Map entries;

    public static final FacetAliasesRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FacetAliasesRegistry();
        }
        return INSTANCE;
    }

    private FacetAliasesRegistry() {
    }

    public List getAliases(String facetId) {
        List aliases = (List)this.getEntries().get(facetId);
        return aliases != null ? aliases : Collections.EMPTY_LIST;
    }

    public List getAliases() {
        ArrayList aliases = new ArrayList();
        for (List entries : this.getEntries().values()) {
            aliases.addAll(entries);
        }
        return aliases;
    }

    private final Map getEntries() {
        if (this.entries == null) {
            this.entries = this.readEntries();
        }
        return this.entries;
    }

    private Map readEntries() {
        HashMap<String, ArrayList<Entry>> entries = new HashMap<String, ArrayList<Entry>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(Model2BasePlugin.getPluginId(), "facetAliases");
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            Entry entry = this.readEntry(elements[i]);
            if (entry != null) {
                ArrayList<Entry> list = (ArrayList<Entry>)entries.get(entry.facetIdRef);
                if (list == null) {
                    list = new ArrayList<Entry>();
                    entries.put(entry.facetIdRef, list);
                }
                list.add(entry);
            }
            ++i;
        }
        return entries;
    }

    private final Entry readEntry(IConfigurationElement element) {
        String facetId = element.getAttribute("facetId");
        if (facetId == null) {
            return null;
        }
        String facetVersion = element.getAttribute("facetVersion");
        if (facetVersion == null) {
            return null;
        }
        String facetIdRef = element.getAttribute("facetIdRef");
        if (facetIdRef == null) {
            return null;
        }
        String facetVersionRef = element.getAttribute("facetVersionRef");
        if (facetVersionRef == null) {
            return null;
        }
        return new Entry(facetId, facetVersion, facetIdRef, facetVersionRef);
    }

    public static class Entry {
        public final String facetId;
        public final String facetVersion;
        public final String facetIdRef;
        public final String facetVersionRef;

        public Entry(String facetId, String facetVersion, String facetIdRef, String facetVersionRef) {
            this.facetId = facetId;
            this.facetVersion = facetVersion;
            this.facetIdRef = facetIdRef;
            this.facetVersionRef = facetVersionRef;
        }
    }
}

