/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base.facet;

import com.ibm.etools.model2.base.facet.ConditionalFacetWeights;
import com.ibm.etools.model2.base.facet.FacetWeightedUtil;
import com.ibm.etools.model2.base.facet.IConditionalFacetWeighted;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class ConditionalFacetWeightedUtil {
    public static void readFacetWeights(IConditionalFacetWeighted weighted, IConfigurationElement element) {
        ConditionalFacetWeights weights = weighted.getConditionalFacetWeights();
        IConfigurationElement[] facetElements = element.getChildren("facet");
        int i = 0;
        while (i < facetElements.length) {
            IConfigurationElement facetElement = facetElements[i];
            String facetId = facetElement.getAttribute("facetId");
            if (facetId != null) {
                int weight = 0;
                String weightString = facetElement.getAttribute("weight");
                if (weightString != null) {
                    try {
                        weight = Integer.parseInt(weightString);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    weight = Math.min(Math.max(weight, 0), 100);
                }
                weights.put(facetId, weight);
            }
            ++i;
        }
    }

    public static IConditionalFacetWeighted getHeaviest(Collection weighteds, IVirtualComponent webComponent) {
        IConditionalFacetWeighted heaviest = null;
        int heaviestWeight = -1;
        for (IConditionalFacetWeighted weighted : weighteds) {
            int weight = ConditionalFacetWeightedUtil.getWeight(weighted, webComponent);
            if (weight <= heaviestWeight) continue;
            heaviestWeight = weight;
            heaviest = weighted;
        }
        return heaviest;
    }

    public static boolean hasWeight(IConditionalFacetWeighted weighted, IVirtualComponent component) {
        ConditionalFacetWeights weights = weighted.getConditionalFacetWeights();
        Iterator iterator = ConditionalFacetWeightedUtil.getFacetIterator(component);
        while (iterator.hasNext()) {
            IProjectFacet facet = (IProjectFacet)iterator.next();
            if (!weights.containsFacet(facet.getId()) || !ConditionalFacetWeightedUtil.checkCondition(weights.getCondition(facet.getId()), component.getProject(), facet)) continue;
            return true;
        }
        return false;
    }

    private static int getWeight(IConditionalFacetWeighted weighted, IVirtualComponent webComponent) {
        int maxWeight = -1;
        ConditionalFacetWeights weights = weighted.getConditionalFacetWeights();
        Iterator iterator = ConditionalFacetWeightedUtil.getFacetIterator(webComponent);
        while (iterator.hasNext()) {
            IProjectFacet facet = (IProjectFacet)iterator.next();
            int weight = weights.get(facet.getId());
            if (weight <= maxWeight || !ConditionalFacetWeightedUtil.checkCondition(weights.getCondition(facet.getId()), webComponent.getProject(), facet)) continue;
            maxWeight = weight;
        }
        return maxWeight;
    }

    private static Iterator getFacetIterator(IVirtualComponent webComponent) {
        return new FacetIterator(FacetWeightedUtil.getFacetVersions(webComponent.getProject()));
    }

    private static boolean checkCondition(String condition, IProject project, IProjectFacet facet) {
        return true;
    }

    static final class FacetIterator
    implements Iterator {
        private final Iterator facetVersionsIterator;

        public FacetIterator(Set facetVersions) {
            this.facetVersionsIterator = facetVersions.iterator();
        }

        public Object next() {
            if (this.facetVersionsIterator.hasNext()) {
                return ((IProjectFacetVersion)this.facetVersionsIterator.next()).getProjectFacet();
            }
            return null;
        }

        @Override
        public void remove() {
            this.facetVersionsIterator.remove();
        }

        @Override
        public boolean hasNext() {
            return this.facetVersionsIterator.hasNext();
        }
    }
}

