/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class Logger {
    private static final String TRACEFILTER_LOCATION = "/debug/tracefilter";
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static final int OK_DEBUG = 200;
    public static final int INFO_DEBUG = 201;
    public static final int WARNING_DEBUG = 202;
    public static final int ERROR_DEBUG = 204;
    private final Plugin plugin;
    private String debugOptionName;

    public Logger(Plugin plugin) {
        this.plugin = plugin;
    }

    private String getPluginId() {
        return this.plugin.getBundle().getSymbolicName();
    }

    private String getDebugOptionName() {
        if (this.debugOptionName == null) {
            this.debugOptionName = String.valueOf(this.getPluginId()) + TRACEFILTER_LOCATION;
        }
        return this.debugOptionName;
    }

    public void log(int level, String message, Throwable exception) {
        if (!(level != 200 && level != 201 && level != 202 && level != 204 || this.isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 201: {
                severity = 1;
                break;
            }
            case 2: 
            case 202: {
                severity = 2;
                break;
            }
            case 4: 
            case 204: {
                severity = 4;
            }
        }
        message = this.getMessageFor(message, exception);
        Status status = new Status(severity, this.getPluginId(), severity, message, exception);
        this.plugin.getLog().log((IStatus)status);
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, Throwable exception) {
        this.log(level, null, exception);
    }

    public void log(String message, Throwable throwable) {
        this.log(4, message, throwable);
    }

    public void log(String message) {
        this.log(4, message, null);
    }

    public void log(Throwable throwable) {
        this.log(4, null, throwable);
    }

    public void trace(String category, String message, Throwable exception) {
        if (this.isTracing(category)) {
            message = this.getMessageFor(message, exception);
            Status status = new Status(0, this.getPluginId(), 0, message, exception);
            this.plugin.getLog().log((IStatus)status);
        }
    }

    public void trace(String category, String message) {
        this.trace(category, message, null);
    }

    public void trace(String category, Throwable exception) {
        this.trace(category, null, exception);
    }

    private boolean isDebugging() {
        return this.plugin.isDebugging();
    }

    private boolean isTracing(String category) {
        String traceFilter;
        if (this.isDebugging() && (traceFilter = Platform.getDebugOption((String)this.getDebugOptionName())) != null) {
            StringTokenizer tokenizer = new StringTokenizer(traceFilter, ",");
            while (tokenizer.hasMoreTokens()) {
                String cat = tokenizer.nextToken().trim();
                if (!category.equals(cat)) continue;
                return true;
            }
        }
        return false;
    }

    private String getMessageFor(String message, Throwable exception) {
        if (message == null) {
            if (exception != null) {
                message = exception.getMessage();
            }
            if (message == null) {
                message = "null";
            }
        }
        return message;
    }
}

