/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.base;

import com.ibm.etools.model2.base.Model2BasePlugin;
import com.ibm.etools.model2.base.nls.ResourceHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class DelegatingSafeRunnable
implements ISafeRunnable {
    private final Object delegateCode;

    public DelegatingSafeRunnable(Object delegateCode) {
        Assert.isNotNull((Object)delegateCode);
        this.delegateCode = delegateCode;
    }

    public void handleException(Throwable exception) {
    }

    public final void run() throws Exception {
        try {
            this.doRun();
        }
        catch (Exception e) {
            this.logException(e);
        }
        catch (LinkageError e) {
            this.logException(e);
        }
    }

    private void logException(Throwable e) {
        if (!(e instanceof OperationCanceledException)) {
            MultiStatus status;
            String pluginId = Model2BasePlugin.getBundleId(this.delegateCode);
            if (pluginId == null) {
                pluginId = Model2BasePlugin.getPluginId();
            }
            String message = NLS.bind((String)ResourceHandler.DelegatingSafeRunnable_0, (Object)pluginId);
            if (e instanceof CoreException) {
                status = new MultiStatus(pluginId, 4, message, e);
                status.merge(((CoreException)e).getStatus());
            } else {
                status = new Status(4, pluginId, 4, message, e);
            }
            Model2BasePlugin.getDefault().getLog().log((IStatus)status);
        }
        this.handleException(e);
    }

    public abstract void doRun() throws Exception;
}

