/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.codegen;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.codegen.CodeGenUtils;
import com.ibm.etools.typedescriptor.ExternalDecimalTD;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.NumberTD;
import com.ibm.etools.typedescriptor.PlatformCompilerInfo;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import java.util.Vector;

public class CodeGenExternalDecimalUtils {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public static String getStringSignFormat(int signFormat) {
        StringBuffer sb = new StringBuffer("MarshallExternalDecimalUtils.SIGN_FORMAT_");
        switch (signFormat) {
            case 0: {
                sb.append("LEADING");
                break;
            }
            case 1: {
                sb.append("TRAILING");
                break;
            }
            case 2: {
                sb.append("LEADING_SEPARATE");
                break;
            }
            case 3: {
                sb.append("TRAILING_SEPARATE");
                break;
            }
            default: {
                sb = new StringBuffer("-1");
            }
        }
        return sb.toString();
    }

    public static String getStringExternalDecimalSign(int externalDecimalSign) {
        StringBuffer sb = new StringBuffer("MarshallExternalDecimalUtils.EXTERNAL_DECIMAL_SIGN_");
        switch (externalDecimalSign) {
            case 0: {
                sb.append("EBCDIC");
                break;
            }
            case 1: {
                sb.append("EBCDIC_CUSTOM");
                break;
            }
            case 2: {
                sb.append("ASCII");
                break;
            }
            case 3: {
                sb.append("UNICODE");
            }
        }
        return sb.toString();
    }

    public static String[] generateExternalDecimalMarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, ExternalDecimalTD typeDescriptor) throws IllegalArgumentException {
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        StringBuffer sb = new StringBuffer("MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer (");
        sb.append(valueName);
        sb.append(", ");
        sb.append(byteArrayName);
        sb.append(", ");
        int size = 0;
        size = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        int virtualDecimalPoint = MarshallParms.getVirtualDecimalPoint((NumberTD)typeDescriptor);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        int signFormat = -1;
        if (signed) {
            signFormat = MarshallParms.getSignFormat(typeDescriptor);
        }
        int externalDecimalSign = MarshallParms.getExternalDecimalSign(typeDescriptor, instanceTD);
        sb.append(offsetString);
        sb.append(", ");
        sb.append(Integer.toString(size));
        sb.append(", ");
        sb.append(new Boolean(signed).toString());
        sb.append(", ");
        if (CodeGenUtils.addVirtualDecimalPoint(javaType)) {
            sb.append(Integer.toString(virtualDecimalPoint));
            sb.append(", ");
        }
        String strSignFormat = CodeGenExternalDecimalUtils.getStringSignFormat(signFormat);
        sb.append(strSignFormat);
        sb.append(", ");
        String strExtDecSign = CodeGenExternalDecimalUtils.getStringExternalDecimalSign(externalDecimalSign);
        sb.append(strExtDecSign);
        if (externalDecimalSign == 1) {
            PlatformCompilerInfo info = MarshallParms.getPlatformInfo(instanceTD);
            String codePage = info.getDefaultHostCodepage();
            if (typeDescriptor.isSetHostCodepage()) {
                codePage = typeDescriptor.getHostCodepage();
            }
            sb.append(", ");
            sb.append("\"" + codePage + "\"");
        }
        sb.append(");");
        genMethods.add(sb.toString());
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }

    public static String[] generateExternalDecimalUnmarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, ExternalDecimalTD typeDescriptor) throws IllegalArgumentException {
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        StringBuffer sb = new StringBuffer(String.valueOf(valueName) + " = MarshallExternalDecimalUtils.unmarshall");
        String typeName = CodeGenUtils.uppercaseFirstLetterInSring(javaType);
        sb.append(String.valueOf(typeName) + "FromBuffer (");
        sb.append(byteArrayName);
        sb.append(", ");
        int size = 0;
        size = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        int virtualDecimalPoint = MarshallParms.getVirtualDecimalPoint((NumberTD)typeDescriptor);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        int signFormat = -1;
        if (signed) {
            signFormat = MarshallParms.getSignFormat(typeDescriptor);
        }
        int externalDecimalSign = MarshallParms.getExternalDecimalSign(typeDescriptor, instanceTD);
        sb.append(offsetString);
        sb.append(", ");
        sb.append(Integer.toString(size));
        sb.append(", ");
        sb.append(new Boolean(signed).toString());
        sb.append(", ");
        if (CodeGenUtils.addVirtualDecimalPoint(javaType)) {
            sb.append(Integer.toString(virtualDecimalPoint));
            sb.append(", ");
        }
        String strSignFormat = CodeGenExternalDecimalUtils.getStringSignFormat(signFormat);
        sb.append(strSignFormat);
        sb.append(", ");
        String strExtDecSign = CodeGenExternalDecimalUtils.getStringExternalDecimalSign(externalDecimalSign);
        sb.append(strExtDecSign);
        if (externalDecimalSign == 1) {
            PlatformCompilerInfo info = MarshallParms.getPlatformInfo(instanceTD);
            String codePage = info.getDefaultHostCodepage();
            if (typeDescriptor.isSetHostCodepage()) {
                codePage = typeDescriptor.getHostCodepage();
            }
            sb.append(", ");
            sb.append("\"" + codePage + "\"");
        }
        sb.append(");");
        genMethods.add(sb.toString());
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }
}

