/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.wizard;

import com.ibm.etools.common.frameworks.internal.datamodel.ComposedOperation;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.jsf.designtime.DesignTimeUtil;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.support.wizard.JsfWizardOperationBase;
import com.ibm.etools.jsf.support.wizard.WizardUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public class JsfBaseFacetInstallDelegate
implements IDelegate {
    public void execute(final IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        JsfWizardOperationBase op;
        IProjectFacet wtpFacet;
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (ProjectFacetsManager.isProjectFacetDefined((String)"jst.jsf") && facetedProject.hasProjectFacet(wtpFacet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf"))) {
            boolean isNonIbmImpl = false;
            IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)project);
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                if (cp[i].getEntryKind() == 5 && new Path("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer").isPrefixOf(cp[i].getPath()) && !cp[i].getPath().toOSString().contains("com.ibm.etools.jsf.util$$ibmjsflib")) {
                    isNonIbmImpl = true;
                }
                ++i;
            }
            if (isNonIbmImpl) {
                if (JsfProjectUtil.getJsfVersion((IProject)project, (boolean)false) != null) {
                    Debug.trace("[wiz] wtp-jsf facet was already present and using non-IBM impl in '" + project.getName() + "' - doing nothing", "wizard");
                    return;
                }
                Debug.trace("[wiz] wtp-jsf facet was already present and using non-IBM impl in '" + project.getName() + "' but no JSF API detected.", "wizard");
            } else {
                Debug.trace("[wiz] installing IBM jsf facet after IBM default wtp-jsf library in '" + project.getName() + "'.", "wizard");
            }
        }
        ComposedOperation operation = new ComposedOperation();
        boolean needsRun = false;
        IDataModel dataModel = null;
        if (config instanceof IDataModel) {
            dataModel = (IDataModel)config;
        }
        if ((op = WizardUtil.getWizardOperation("jsf.base", project, dataModel)) != null && !op.isAlreadyRun(project)) {
            needsRun = true;
            op.setTargetProject(project);
            operation.addRunnable((WTPOperation)op);
        }
        if ((op = WizardUtil.getWizardOperation("jsf.ri", project, dataModel)) != null && !op.isAlreadyRun(project)) {
            needsRun = true;
            op.setTargetProject(project);
            if (config instanceof IDataModel) {
                op.setDataModel((IDataModel)config);
            }
            operation.addRunnable((WTPOperation)op);
        }
        if (needsRun) {
            try {
                operation.run(monitor);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.isNullRuntime(project)) {
            Display display;
            if (ErrorDialog.AUTOMATED_MODE || SafeRunnable.getIgnoreErrors()) {
                throw new IllegalStateException(MessageFormat.format(Messages.JsfBaseFacetInstallDelegate_Infotext, project.getName()));
            }
            if (PlatformUI.isWorkbenchRunning() && (display = Display.getDefault()) != null) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = display.getActiveShell();
                        String label = MessageFormat.format(Messages.JsfBaseFacetInstallDelegate_Infotext, project.getName());
                        MessageDialog.openInformation((Shell)shell, (String)Messages.JsfBaseFacetInstallDelegate_Title, (String)label);
                    }
                });
            }
        }
        DesignTimeUtil.setupDTResolversForProject(project);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isNullRuntime(IProject project) {
        try {
            IRuntimeComponent component;
            IRuntime runtime = ProjectFacetsManager.create((IProject)project).getPrimaryRuntime();
            if (runtime == null) {
                return true;
            }
            List runtimeComponents = runtime.getRuntimeComponents();
            Iterator componentsIter = runtimeComponents.iterator();
            do {
                if (componentsIter.hasNext()) continue;
                return true;
            } while ((component = (IRuntimeComponent)componentsIter.next()) == null || component.getRuntimeComponentType().getId() == null);
            return false;
        }
        catch (CoreException coreException) {}
        return true;
    }
}

