/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.wizard.jsfaction;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigScheme;
import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigSchemeManager;
import com.ibm.etools.jsf.facesconfig.util.JSFFacesConfigUtil;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.wizard.jsfaction.IMBDataModelProperties;
import com.ibm.etools.jsf.support.wizard.jsfaction.MBCreationOperation;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class MBDataModelProvider
extends AbstractDataModelProvider
implements IMBDataModelProperties {
    private DataModelPropertyDescriptor[] facesConfigFiles = null;

    public static boolean containsManagedBean(List<ManagedBeanType> managedBeans, ManagedBeanType mb) {
        String beanName = mb.getManagedBeanName() != null ? mb.getManagedBeanName().getTextContent() : null;
        ListIterator<ManagedBeanType> it = managedBeans.listIterator();
        while (it.hasNext()) {
            String configFileBeanName;
            ManagedBeanType configFileBean = it.next();
            String string = configFileBeanName = configFileBean.getManagedBeanName() != null ? configFileBean.getManagedBeanName().getTextContent() : null;
            if (configFileBeanName == null || !configFileBeanName.equals(beanName)) continue;
            return true;
        }
        return false;
    }

    public static List<IProject> getAllFacesProjects() {
        IProject[] allprojects;
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = allprojects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allprojects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (JsfProjectUtil.isJsfProject((IProject)project)) {
                projects.add(project);
            }
            ++n2;
        }
        return projects;
    }

    private IStatus canWrite() {
        IVirtualComponent component = (IVirtualComponent)this.model.getProperty("IMBDataModelProerties.COMPONENT");
        if (component == null) {
            return WTPCommonPlugin.createErrorStatus((String)Messages.MBDataModelProvider_1);
        }
        IJavaProject javaProject = JavaCore.create((IProject)component.getProject());
        if (javaProject == null) {
            return WTPCommonPlugin.createErrorStatus((String)Messages.MBDataModelProvider_1);
        }
        String className = this.model.getStringProperty("IMBDataModelProperties.BEAN_CLASS");
        if (className == null || className.trim().length() == 0) {
            return WTPCommonPlugin.createErrorStatus((String)Messages.MBDataModelProvider_2);
        }
        IStatus status = JavaConventions.validateJavaTypeName((String)className);
        MultiStatus multi = new MultiStatus(status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
        try {
            IType type = javaProject.findType(className);
            if (type == null) {
                IStatus s = WTPCommonPlugin.createErrorStatus((String)Messages.MBDataModelProvider_3);
                multi.merge(s);
            } else if (type.isReadOnly()) {
                IStatus s = WTPCommonPlugin.createErrorStatus((String)Messages.MBDataModelProvider_4);
                multi.merge(s);
            } else {
                IStatus s = OK_STATUS;
                multi.merge(s);
            }
        }
        catch (JavaModelException javaModelException) {
            IStatus s = WTPCommonPlugin.createErrorStatus((String)Messages.MBDataModelProvider_5);
            multi.merge(s);
        }
        return multi;
    }

    private boolean checkIfActionExists(String action) {
        String className = this.model.getStringProperty("IMBDataModelProperties.BEAN_CLASS");
        IVirtualComponent comp = (IVirtualComponent)this.model.getProperty("IMBDataModelProerties.COMPONENT");
        if (className == null || className.trim().length() == 0 || comp == null) {
            return false;
        }
        IProject prj = comp.getProject();
        IJavaProject jp = JavaCore.create((IProject)prj);
        try {
            IMethod method;
            IType t = jp.findType(className);
            if (t != null && (method = t.getMethod(action, new String[0])) != null) {
                return method.exists();
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private boolean checkIfBeanExists(String beanName) {
        EList<ManagedBeanType> managedBeans = this.getAllManagedBeansFromFacesConfig();
        if (managedBeans == null || managedBeans.isEmpty()) {
            return false;
        }
        FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
        FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
        ManagedBeanType newManagedBean = facesConfigFactory.createManagedBeanType();
        assert (newManagedBean != null);
        ManagedBeanNameType name = facesConfigFactory.createManagedBeanNameType();
        name.setTextContent(this.model.getStringProperty("IMBDataModelProperties.BEAN_NAME"));
        newManagedBean.setManagedBeanName(name);
        return MBDataModelProvider.containsManagedBean(managedBeans, newManagedBean);
    }

    private IStatus checkIfBeanMappedToADifferentClassOrScope(String beanName) {
        EList<ManagedBeanType> managedBeans = this.getAllManagedBeansFromFacesConfig();
        String modelBeanClass = this.model.getStringProperty("IMBDataModelProperties.BEAN_CLASS");
        String modelBeanScope = "";
        Object obj = this.model.getProperty("IMBDataModelProperties.SCOPE");
        if (obj instanceof DataModelPropertyDescriptor) {
            modelBeanScope = ((DataModelPropertyDescriptor)this.model.getProperty("IMBDataModelProperties.SCOPE")).toString();
        } else if (obj instanceof String) {
            modelBeanScope = (String)obj;
        }
        ListIterator it = managedBeans.listIterator();
        while (it.hasNext()) {
            String configBeanScope;
            String configFileBeanName;
            ManagedBeanType configFileBean = (ManagedBeanType)it.next();
            String string = configFileBeanName = configFileBean.getManagedBeanName() != null ? configFileBean.getManagedBeanName().getTextContent() : null;
            if (configFileBeanName == null || !configFileBeanName.equals(beanName)) continue;
            String configBeanClass = configFileBean.getManagedBeanClass() != null ? configFileBean.getManagedBeanClass().getTextContent() : null;
            String string2 = configBeanScope = configFileBean.getManagedBeanScope() != null ? configFileBean.getManagedBeanScope().getTextContent() : null;
            if (modelBeanScope != null && modelBeanScope.trim().length() > 0 && !configBeanScope.equals(modelBeanScope)) {
                return WTPCommonPlugin.createErrorStatus((String)NLS.bind((String)Messages.MBDataModelProvider_10, (Object)beanName));
            }
            if (modelBeanClass == null || modelBeanClass.trim().length() <= 0 || configBeanClass.equals(modelBeanClass)) continue;
            return WTPCommonPlugin.createErrorStatus((String)NLS.bind((String)Messages.MBDataModelProvider_11, (Object)beanName));
        }
        return OK_STATUS;
    }

    private EList<ManagedBeanType> getAllManagedBeansFromFacesConfig() {
        FacesConfigArtifactEdit edit = null;
        EList managedBeans = null;
        try {
            String configFile = "";
            Object cf = this.model.getProperty("IMBDataModelProperties.CONFIG_FILE");
            if (cf == null) {
                return null;
            }
            if (cf instanceof DataModelPropertyDescriptor) {
                configFile = ((DataModelPropertyDescriptor)cf).toString();
            } else if (cf instanceof String) {
                configFile = (String)cf;
            }
            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)((IVirtualComponent)this.model.getProperty("IMBDataModelProerties.COMPONENT")).getProject(), (String)configFile);
            FacesConfigType facesConfig = edit.getFacesConfig();
            if (facesConfig != null) {
                EList eList = managedBeans = facesConfig.getManagedBean();
                return eList;
            }
            EList eList = managedBeans;
            return eList;
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private String getBeanClassName() {
        String beanName = this.model.getStringProperty("IMBDataModelProperties.BEAN_NAME");
        return this.getClassForBeanName(beanName);
    }

    private List<String> getBeanScope() {
        EList<ManagedBeanType> managedBeans = this.getAllManagedBeansFromFacesConfig();
        Object obj = this.model.getProperty("IMBDataModelProperties.BEAN_NAME");
        String beanName = "";
        ArrayList<String> scopes = new ArrayList<String>();
        if (managedBeans == null || managedBeans.size() == 0 || obj == null) {
            return this.getDefaultBeanScopeList();
        }
        if (obj instanceof DataModelPropertyDescriptor) {
            beanName = ((DataModelPropertyDescriptor)obj).toString();
        } else if (obj instanceof String) {
            beanName = (String)obj;
        }
        int i = 0;
        while (i < managedBeans.size()) {
            ManagedBeanType mb = (ManagedBeanType)managedBeans.get(i);
            if (mb.getManagedBeanName().getTextContent().equals(beanName)) {
                scopes.add(mb.getManagedBeanScope().getTextContent());
                return scopes;
            }
            ++i;
        }
        return this.getDefaultBeanScopeList();
    }

    private String getClassForBeanName(String beanName) {
        if (beanName == null || beanName.trim().length() == 0) {
            return null;
        }
        EList<ManagedBeanType> managedBeans = this.getAllManagedBeansFromFacesConfig();
        ListIterator it = managedBeans.listIterator();
        while (it.hasNext()) {
            String configFileBeanName;
            ManagedBeanType configFileBean = (ManagedBeanType)it.next();
            String string = configFileBeanName = configFileBean.getManagedBeanName() != null ? configFileBean.getManagedBeanName().getTextContent() : null;
            if (!beanName.equals(configFileBeanName)) continue;
            return configFileBean.getManagedBeanClass() != null ? configFileBean.getManagedBeanClass().getTextContent().trim() : null;
        }
        return null;
    }

    private IVirtualComponent getComponent() {
        return (IVirtualComponent)this.model.getProperty("IMBDataModelProerties.COMPONENT");
    }

    private String getConfigFileName() {
        Object configFileObject = this.model.getProperty("IMBDataModelProperties.CONFIG_FILE");
        if (configFileObject != null) {
            return configFileObject.toString();
        }
        return null;
    }

    private List<String> getDefaultBeanScopeList() {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("none");
        scopes.add("request");
        scopes.add("session");
        scopes.add("application");
        return scopes;
    }

    private DataModelPropertyDescriptor getDefaultConfigFile() {
        String projectName = this.getDefaultProjectName();
        if (projectName == null) {
            return null;
        }
        IVirtualComponent component = (IVirtualComponent)this.model.getProperty("IMBDataModelProerties.COMPONENT");
        if (component == null) {
            return null;
        }
        IProject project = component.getProject();
        if (project == null) {
            return null;
        }
        FacesConfigScheme scheme = FacesConfigSchemeManager.getInstance().getScheme("managedBean", project);
        if (scheme == null) {
            return null;
        }
        String configPath = scheme.getFacesConfigPath("managedBean", (IResource)project, 0);
        if (configPath == null) {
            return null;
        }
        if (this.facesConfigFiles == null) {
            this.setFacesConfigFiles();
        }
        if (this.facesConfigFiles.length > 0) {
            int i = 0;
            while (i < this.facesConfigFiles.length) {
                if (this.facesConfigFiles[i].toString().equals(configPath)) {
                    return this.facesConfigFiles[i];
                }
                ++i;
            }
            return this.facesConfigFiles[0];
        }
        return null;
    }

    public IDataModelOperation getDefaultOperation() {
        MBCreationOperation op = new MBCreationOperation(this.getDataModel());
        return op;
    }

    private String getDefaultProjectName() {
        IStructuredSelection ss;
        Object o;
        IVirtualComponent component = (IVirtualComponent)this.model.getProperty("IMBDataModelProerties.COMPONENT");
        if (component != null) {
            if (JsfProjectUtil.isJsfProject((IProject)component.getProject())) {
                return component.getProject().getName();
            }
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && (o = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)o;
            IProject p = null;
            IResource resource = (IResource)a.getAdapter(IResource.class);
            if (resource != null) {
                p = resource.getProject();
            }
            if (p == null && (resource = (IResource)Platform.getAdapterManager().getAdapter(o, IResource.class)) != null) {
                p = resource.getProject();
            }
            if (p == null) {
                return null;
            }
            if (JsfProjectUtil.isJsfProject((IProject)p)) {
                return p.getName();
            }
        }
        return null;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IMBDataModelProperties.PROJECT_NAME")) {
            return this.getDefaultProjectName();
        }
        if (propertyName.equals("IMBDataModelProperties.CONFIG_FILE")) {
            return this.getDefaultConfigFile();
        }
        if (propertyName.equals("IMBDataModelProperties.BEAN_NAME")) {
            List<String> beans = this.getManagedBeanNames();
            if (!beans.isEmpty()) {
                return beans.get(0);
            }
            return null;
        }
        if (propertyName.equals("IMBDataModelProperties.SCOPE")) {
            return this.getBeanScope().get(0);
        }
        if (propertyName.equals("IMBDataModelProperties.BEAN_CLASS")) {
            return this.getBeanClassName();
        }
        if (propertyName.equals("IMBDataModelProerties.COMPONENT")) {
            return ComponentUtilities.getComponent((String)this.model.getStringProperty("IMBDataModelProperties.PROJECT_NAME"));
        }
        return null;
    }

    public DataModelPropertyDescriptor[] getFacesConfigFiles() {
        return this.facesConfigFiles;
    }

    private List<String> getManagedBeanNames() {
        IProject project;
        String configFileName = this.getConfigFileName();
        if (configFileName != null && (project = this.getProject()) != null) {
            ArrayList<String> names = new ArrayList<String>();
            Collection links = FacesLinkUtil.getAllFacesManagedBeans((IProject)project, (boolean)true, null);
            for (ILink link : links) {
                names.add(link.getName());
            }
            return names;
        }
        return Collections.emptyList();
    }

    private IProject getProject() {
        IVirtualComponent component = this.getComponent();
        if (component != null) {
            return component.getProject();
        }
        return null;
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IMBDataModelProperties.PROJECT_NAME");
        propertyNames.add("IMBDataModelProperties.CONFIG_FILE");
        propertyNames.add("IMBDataModelProperties.BEAN_NAME");
        propertyNames.add("IMBDataModelProperties.SCOPE");
        propertyNames.add("IMBDataModelProperties.METHODNAME");
        propertyNames.add("IMBDataModelProperties.RETURNTYPE");
        propertyNames.add("IMBDataModelProperties.PARAMS");
        propertyNames.add("IMBDataModelProperties.EXCEPTIONS");
        propertyNames.add("IMBDataModelProperties.BEAN_CLASS");
        propertyNames.add("IMBDataModelProerties.CREATE_BEAN_CLASS");
        propertyNames.add("IMBDataModelProerties.COMPONENT");
        return propertyNames;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("IMBDataModelProperties.CONFIG_FILE")) {
            this.setFacesConfigFiles();
            return this.facesConfigFiles;
        }
        if (propertyName.equals("IMBDataModelProperties.SCOPE")) {
            List<String> scopes = this.getBeanScope();
            if (!scopes.isEmpty()) {
                DataModelPropertyDescriptor[] beanScopes = new DataModelPropertyDescriptor[scopes.size()];
                int i = 0;
                for (String name : scopes) {
                    beanScopes[i] = new DataModelPropertyDescriptor((Object)name);
                    ++i;
                }
                return beanScopes;
            }
            return null;
        }
        if (propertyName.equals("IMBDataModelProperties.BEAN_NAME")) {
            List<String> names = this.getManagedBeanNames();
            if (!names.isEmpty()) {
                DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[names.size()];
                int i = 0;
                for (String name : names) {
                    descriptors[i] = new DataModelPropertyDescriptor((Object)name);
                    ++i;
                }
                return descriptors;
            }
            return null;
        }
        return null;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IMBDataModelProerties.COMPONENT")) {
            throw new RuntimeException("");
        }
        if (propertyName.equals("IMBDataModelProperties.PROJECT_NAME")) {
            this.model.notifyPropertyChange("IMBDataModelProerties.COMPONENT", 1);
            this.model.setProperty("IMBDataModelProperties.CONFIG_FILE", null);
            this.model.notifyPropertyChange("IMBDataModelProperties.CONFIG_FILE", 4);
            this.model.setProperty("IMBDataModelProperties.BEAN_NAME", null);
            this.model.notifyPropertyChange("IMBDataModelProperties.BEAN_NAME", 4);
            this.model.notifyPropertyChange("IMBDataModelProperties.SCOPE", 4);
            this.model.setProperty("IMBDataModelProperties.BEAN_CLASS", null);
            this.model.notifyPropertyChange("IMBDataModelProperties.BEAN_CLASS", 4);
        } else if (propertyName.equals("IMBDataModelProperties.CONFIG_FILE")) {
            this.model.setProperty("IMBDataModelProperties.BEAN_NAME", null);
            this.model.notifyPropertyChange("IMBDataModelProperties.BEAN_NAME", 4);
            this.model.notifyPropertyChange("IMBDataModelProperties.SCOPE", 4);
            this.model.setProperty("IMBDataModelProperties.BEAN_CLASS", null);
            this.model.notifyPropertyChange("IMBDataModelProperties.BEAN_CLASS", 4);
        } else if (propertyName.equals("IMBDataModelProperties.BEAN_NAME")) {
            this.model.setProperty("IMBDataModelProperties.SCOPE", null);
            this.model.notifyPropertyChange("IMBDataModelProperties.SCOPE", 4);
            String beanProperty = this.getClassForBeanName((String)propertyValue);
            this.model.setProperty("IMBDataModelProperties.BEAN_CLASS", (Object)beanProperty);
            this.model.notifyPropertyChange("IMBDataModelProperties.BEAN_CLASS", 4);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private DataModelPropertyDescriptor[] setFacesConfigFiles() {
        IVirtualComponent component = (IVirtualComponent)this.model.getProperty("IMBDataModelProerties.COMPONENT");
        if (component != null) {
            String[] facesConfigPaths = JSFFacesConfigUtil.getFacesConfigPaths((IProject)component.getProject());
            this.facesConfigFiles = new DataModelPropertyDescriptor[facesConfigPaths.length];
            int i = 0;
            while (i < facesConfigPaths.length) {
                String path = facesConfigPaths[i];
                this.facesConfigFiles[i] = new DataModelPropertyDescriptor((Object)path);
                ++i;
            }
            return this.facesConfigFiles;
        }
        return null;
    }

    public IStatus validate(String name) {
        if (name.equals("IMBDataModelProperties.PROJECT_NAME")) {
            return this.validateProjects();
        }
        if (name.equals("IMBDataModelProperties.BEAN_NAME") || name.equals("IMBDataModelProperties.SCOPE")) {
            return this.validateManagedBean();
        }
        if (name.equals("IMBDataModelProperties.BEAN_CLASS")) {
            return this.canWrite();
        }
        if (name.equals("IMBDataModelProperties.METHODNAME")) {
            return this.validateBeanAction();
        }
        return super.validate(name);
    }

    private IStatus validateBeanAction() {
        String action = this.model.getStringProperty("IMBDataModelProperties.METHODNAME");
        if (action == null || action.length() == 0) {
            return WTPCommonPlugin.createErrorStatus((String)Messages.MBDataModelProvider_7);
        }
        if (this.checkIfActionExists(action)) {
            return WTPCommonPlugin.createErrorStatus((String)NLS.bind((String)Messages.MBDataModelProvider_8, (Object)action));
        }
        return OK_STATUS;
    }

    private IStatus validateManagedBean() {
        String beanName = this.model.getStringProperty("IMBDataModelProperties.BEAN_NAME");
        Object status = null;
        status = beanName == null || beanName.length() == 0 ? new Status(4, JsfPlugin.getDefault().getBundle().getSymbolicName(), Messages.MBDataModelProvider_6) : Status.OK_STATUS;
        if (!status.isOK()) {
            return status;
        }
        if (this.checkIfBeanExists(beanName)) {
            return this.checkIfBeanMappedToADifferentClassOrScope(beanName);
        }
        return OK_STATUS;
    }

    private IStatus validateProjects() {
        if (MBDataModelProvider.getAllFacesProjects().size() == 0) {
            return WTPCommonPlugin.createErrorStatus((String)Messages.MBDataModelProvider_1);
        }
        return OK_STATUS;
    }
}

