/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.wizard.jsfaction;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.wizard.jsfaction.FacesProjectSelectionDialog;
import com.ibm.etools.jsf.support.wizard.jsfaction.IMBDataModelProperties;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class MBCreationWizardPage
extends DataModelWizardPage
implements IMBDataModelProperties {
    protected Text projNameField;
    protected Button projBrowse;
    protected Combo configFileField;
    protected Combo beanName;
    protected Combo scope;
    protected Text action;
    protected Text beanClassNameField;
    protected Button newClass;
    protected Button classBrowse;
    protected Button createClass;
    protected FormToolkit kit;
    private boolean isFacesAction = true;

    protected MBCreationWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(Messages.MBCreationWizard_CreateAction);
        this.setDescription(Messages.MBCreationWizard_CreateActionDesc);
    }

    protected MBCreationWizardPage(IDataModel model, String pageName, boolean isFacesAction) {
        super(model, pageName);
        this.isFacesAction = isFacesAction;
        if (isFacesAction) {
            this.setTitle(Messages.MBCreationWizard_CreateAction);
            this.setDescription(Messages.MBCreationWizard_CreateActionDesc);
        } else {
            this.setTitle(Messages.MBCreationWizard_CreateAction2);
            this.setDescription(Messages.MBCreationWizard_CreateActionDesc2);
        }
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IMBDataModelProperties.PROJECT_NAME", "IMBDataModelProperties.BEAN_NAME", "IMBDataModelProperties.SCOPE", "IMBDataModelProperties.BEAN_CLASS", "IMBDataModelProperties.METHODNAME", "IMBDataModelProperties.RETURNTYPE", "IMBDataModelProperties.PARAMS", "IMBDataModelProperties.EXCEPTIONS"};
    }

    public void dispose() {
        if (this.kit != null) {
            try {
                this.kit.dispose();
            }
            finally {
                this.kit = null;
            }
        }
        super.dispose();
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.kit = new FormToolkit(parent.getDisplay());
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        Composite projectGroup = new Composite(composite, 0);
        this.createProjectGroup(projectGroup);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(projectGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)projectGroup);
        Group configGroup = new Group(composite, 0);
        configGroup.setText(Messages.MBCreationWizardPage_FacesConfig);
        this.createConfigGroup((Composite)configGroup);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)configGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)configGroup);
        Group beanClassGroup = new Group(composite, 0);
        beanClassGroup.setText(Messages.MBCreationWizardPage_JavaConfig);
        this.createBeanClassGroup((Composite)beanClassGroup);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)beanClassGroup);
        GridDataFactory.fillDefaults().applyTo((Control)beanClassGroup);
        return composite;
    }

    protected void createProjectGroup(Composite parent) {
        Label lb1 = new Label(parent, 0);
        lb1.setText(Messages.MBCreationWizardPage_Project);
        this.projNameField = new Text(parent, 2056);
        this.projNameField.addListener(24, (Listener)this);
        this.projNameField.addListener(13, (Listener)this);
        GridDataFactory.defaultsFor((Control)this.projNameField).grab(true, false).applyTo((Control)this.projNameField);
        this.synchHelper.synchText(this.projNameField, "IMBDataModelProperties.PROJECT_NAME", new Control[]{lb1});
        this.projBrowse = new Button(parent, 8);
        this.projBrowse.setText(Messages.MBCreationWizardPage_Browse);
        this.projBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MBCreationWizardPage.this.handleProjectBrowseButtonPressed();
            }
        });
    }

    protected void createConfigGroup(Composite parent) {
        Label configFileLabel = new Label(parent, 0);
        configFileLabel.setText(Messages.MBCreationWizardPage_ConfigFileName);
        this.configFileField = new Combo(parent, 2056);
        this.synchHelper.synchCombo(this.configFileField, "IMBDataModelProperties.CONFIG_FILE", new Control[]{configFileLabel});
        GridDataFactory.defaultsFor((Control)this.configFileField).grab(true, false).applyTo((Control)this.configFileField);
        Label beanNameLabel = new Label(parent, 0);
        beanNameLabel.setText(Messages.MBCreationWizardPage_BeanName);
        this.beanName = new Combo(parent, 2048);
        this.synchHelper.synchCombo(this.beanName, "IMBDataModelProperties.BEAN_NAME", new Control[]{beanNameLabel, this.configFileField});
        GridDataFactory.defaultsFor((Control)this.beanName).grab(true, false).applyTo((Control)this.beanName);
        Label scopeLabel = new Label(parent, 0);
        scopeLabel.setText(Messages.MBCreationWizardPage_Scope);
        this.scope = new Combo(parent, 2056);
        this.synchHelper.synchCombo(this.scope, "IMBDataModelProperties.SCOPE", new Control[]{scopeLabel, this.beanName});
        GridDataFactory.defaultsFor((Control)this.scope).grab(true, false).applyTo((Control)this.scope);
    }

    protected void createBeanClassGroup(Composite parent) {
        Hyperlink beanClassLabel = this.kit.createHyperlink(parent, Messages.MBCreationWizardPage_BeanClass, 0);
        beanClassLabel.setBackground(parent.getBackground());
        beanClassLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                MBCreationWizardPage.this.handleNewClassButtonPressed();
            }
        });
        this.beanClassNameField = new Text(parent, 2048);
        this.beanClassNameField.addListener(24, (Listener)this);
        this.beanClassNameField.addListener(13, (Listener)this);
        this.synchHelper.synchText(this.beanClassNameField, "IMBDataModelProperties.BEAN_CLASS", new Control[]{beanClassLabel});
        GridDataFactory.defaultsFor((Control)this.beanClassNameField).grab(true, false).applyTo((Control)this.beanClassNameField);
        this.classBrowse = new Button(parent, 8);
        this.classBrowse.setText(Messages.MBCreationWizardPage_Browse2);
        this.classBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MBCreationWizardPage.this.handleClassBrowseButtonPressed(e.display);
            }
        });
        Label actionLabel = new Label(parent, 0);
        if (this.isFacesAction) {
            actionLabel.setText(Messages.MBCreationWizardPage_Method);
        } else {
            actionLabel.setText(Messages.MBCreationWizardPage_Method2);
        }
        this.action = new Text(parent, 2048);
        this.synchHelper.synchText(this.action, "IMBDataModelProperties.METHODNAME", new Control[]{actionLabel});
        GridDataFactory.defaultsFor((Control)this.action).grab(true, false).applyTo((Control)this.action);
    }

    private void handleProjectBrowseButtonPressed() {
        IProject prj;
        FacesProjectSelectionDialog diag = new FacesProjectSelectionDialog(this.getShell()){

            @Override
            protected boolean includeProject(IProject project) {
                return JsfProjectUtil.isJsfProject((IProject)project);
            }
        };
        if (diag.open() == 0 && (prj = diag.getProject()) != null) {
            this.model.setProperty("IMBDataModelProperties.PROJECT_NAME", (Object)prj.getName());
        }
    }

    private void handleNewClassButtonPressed() {
        NewClassWizardPage page = new NewClassWizardPage();
        IProject project = ((IVirtualComponent)this.model.getProperty("IMBDataModelProerties.COMPONENT")).getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        page.init((IStructuredSelection)new StructuredSelection((Object)javaProject));
        IPackageFragmentRoot packageFragmentRoot = javaProject.getPackageFragmentRoot(this.getPackageName(project));
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(this.getPackageName(project));
        page.setPackageFragment(packageFragment, true);
        page.setTypeName(this.getActionClassName(), true);
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        action.setOpenEditorOnFinish(false);
        action.setConfiguredWizardPage(page);
        action.setShell(this.getShell());
        action.run();
        IJavaElement element = action.getCreatedElement();
        if (element != null) {
            IJavaElement jelem = element.getParent();
            jelem = jelem.getParent();
            String className = "";
            if (jelem instanceof IPackageFragment) {
                className = ((IPackageFragment)jelem).getElementName();
                className = className == null || className.trim().length() == 0 ? "" : String.valueOf(className) + ".";
            }
            className = String.valueOf(className) + element.getElementName();
            this.model.setProperty("IMBDataModelProperties.BEAN_CLASS", (Object)className);
        }
    }

    private void handleClassBrowseButtonPressed(Display display) {
        IVirtualComponent component = (IVirtualComponent)this.model.getProperty("IMBDataModelProerties.COMPONENT");
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)display.getActiveShell(), (IRunnableContext)this.getContainer(), (IProject)component.getProject(), (int)2, (boolean)false);
            if (dialog.open() == 0 && dialog.getResult() != null && dialog.getResult().length == 1) {
                IType type = (IType)dialog.getResult()[0];
                this.model.setProperty("IMBDataModelProperties.BEAN_CLASS", (Object)type.getFullyQualifiedName());
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private String getPackageName(IProject prj) {
        String pkgName = prj.getName();
        if (pkgName == null || pkgName.length() == 0) {
            return "";
        }
        pkgName = this.isFacesAction ? String.valueOf(pkgName.toLowerCase()) + ".actions" : String.valueOf(pkgName.toLowerCase()) + ".events";
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = JavaCore.create((IProject)prj).getAllPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                if (!packageFragmentRoot.isArchive()) {
                    IJavaElement[] packFragments;
                    IJavaElement[] iJavaElementArray = packFragments = packageFragmentRoot.getChildren();
                    int n3 = packFragments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElement javaElement = iJavaElementArray[n4];
                        if (pkgName.equalsIgnoreCase(javaElement.getElementName())) {
                            return javaElement.getElementName();
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return pkgName;
    }

    private String getActionClassName() {
        char[] name;
        String actionName = this.model.getStringProperty("IMBDataModelProperties.BEAN_CLASS");
        if (actionName == null || actionName.length() == 0) {
            actionName = this.model.getStringProperty("IMBDataModelProperties.BEAN_NAME");
        }
        if (actionName == null || actionName.length() == 0) {
            actionName = "";
        }
        if ((name = actionName.toCharArray()).length > 0) {
            name[0] = Character.toUpperCase(name[0]);
        }
        return new String(name);
    }

    protected boolean showValidationErrorsOnEnter() {
        IProject[] projects;
        boolean foundFacesProject = false;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (JsfProjectUtil.isJsfProject((IProject)project)) {
                foundFacesProject = true;
                break;
            }
            ++n2;
        }
        if (!foundFacesProject) {
            this.disableFields();
            return true;
        }
        return super.showValidationErrorsOnEnter();
    }

    private void disableFields() {
        this.projBrowse.setEnabled(false);
        this.configFileField.setEnabled(false);
        this.beanName.setEnabled(false);
        this.scope.setEnabled(false);
        this.action.setEnabled(false);
        this.beanClassNameField.setEnabled(false);
        this.newClass.setEnabled(false);
        this.classBrowse.setEnabled(false);
    }
}

